<?php

return [
    'users' => [
        'sessions' => [
            'email'                  => 'Adresse e-mail',
            'forget-password-link'   => 'Mot de passe oublié ?',
            'password'               => 'Mot de passe',
            'powered-by-description' => 'Propulsé par :bagisto, un projet open-source par :webkul.',
            'submit-btn'             => 'Se connecter',
            'title'                  => 'Se connecter',
        ],

        'forget-password' => [
            'create' => [
                'email'                  => 'Adresse e-mail enregistrée',
                'email-not-exist'        => 'L\'adresse e-mail n\'existe pas',
                'page-title'             => 'Mot de passe oublié',
                'powered-by-description' => 'Propulsé par :bagisto, un projet open-source par :webkul.',
                'reset-link-sent'        => 'Lien de réinitialisation du mot de passe envoyé',
                'sign-in-link'           => 'Retour à la connexion ?',
                'submit-btn'             => 'Réinitialiser',
                'title'                  => 'Récupérer le mot de passe',
            ],
        ],

        'reset-password' => [
            'back-link-title'        => 'Retour à la connexion ?',
            'confirm-password'       => 'Confirmer le mot de passe',
            'email'                  => 'Adresse e-mail enregistrée',
            'password'               => 'Mot de passe',
            'powered-by-description' => 'Propulsé par :bagisto, un projet open-source par :webkul.',
            'submit-btn'             => 'Réinitialiser le mot de passe',
            'title'                  => 'Réinitialiser le mot de passe',
        ],
    ],

    'notifications' => [
        'description-text' => 'Lister toutes les notifications',
        'marked-success'   => 'Toutes les notifications ont été marquées comme lues',
        'no-record'        => 'Aucun enregistrement trouvé',
        'of'               => 'de',
        'per-page'         => 'Par page',
        'read-all'         => 'Marquer comme lu',
        'title'            => 'Notifications',
        'view-all'         => 'Voir tout',

        'order-status-messages' => [
            'all'             => 'Tout',
            'canceled'        => 'Commande annulée',
            'closed'          => 'Commande fermée',
            'completed'       => 'Commande terminée',
            'pending'         => 'Commande en attente',
            'pending-payment' => 'Paiement en attente',
            'processing'      => 'Commande en cours de traitement',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Retour',
            'change-password'   => 'Modifier le mot de passe',
            'confirm-password'  => 'Confirmer le mot de passe',
            'current-password'  => 'Mot de passe actuel',
            'email'             => 'Email',
            'general'           => 'Général',
            'invalid-password'  => 'Le mot de passe actuel que vous avez saisi est incorrect.',
            'name'              => 'Nom',
            'password'          => 'Mot de passe',
            'profile-image'     => 'Image de profil',
            'save-btn'          => 'Enregistrer le compte',
            'title'             => 'Mon compte',
            'update-success'    => 'Compte mis à jour avec succès',
            'upload-image-info' => 'Téléchargez une image de profil (110px X 110px) au format PNG ou JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Ajouter un client',
            'add-product'                 => 'Ajouter un produit',
            'all-channels'                => 'Tous les canaux',
            'attribute-code'              => 'Code d\'attribut',
            'average-sale'                => 'Vente moyenne par commande',
            'color'                       => 'Couleur',
            'customer-info'               => 'Aucun client trouvé avec le plus de ventes',
            'customer-with-most-sales'    => 'Client ayant le plus de ventes',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Seuil de Vide',
            'empty-threshold-description' => 'Aucun produit n\'est disponible',
            'end-date'                    => 'Date de fin',
            'from'                        => 'De',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ autres images',
            'order'                       => ':total_orders commandes',
            'order-count'                 => ':count commandes',
            'order-id'                    => '#:id',
            'overall-details'             => 'Détails globaux',
            'pay-by'                      => 'Payé par - :method',
            'product-count'               => ':count produits',
            'product-image'               => 'Image du produit',
            'product-info'                => 'Ajoutez des produits connexes en cours de route.',
            'product-number'              => 'Produit - :product_number',
            'revenue'                     => 'Revenu :total',
            'sale-count'                  => ':count ventes',
            'sales'                       => 'Ventes',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => 'Date de début',
            'stock-threshold'             => 'Seuil de stock',
            'store-stats'                 => 'Statistiques du magasin',
            'title'                       => 'Tableau de bord',
            'to'                          => 'À',
            'today-customers'             => 'Clients d\'aujourd\'hui',
            'today-details'               => 'Détails d\'aujourd\'hui',
            'today-orders'                => 'Commandes d\'aujourd\'hui',
            'today-sales'                 => 'Ventes d\'aujourd\'hui',
            'top-performing-categories'   => 'Catégories les plus performantes',
            'top-selling-products'        => 'Produits les plus vendus',
            'total-customers'             => 'Total des clients',
            'total-orders'                => 'Total des commandes',
            'total-sales'                 => 'Total des ventes',
            'total-stock'                 => ':total_stock stock',
            'total-unpaid-invoices'       => 'Total des factures impayées',
            'unique-visitors'             => ':count unique',
            'user-info'                   => 'Revoyez rapidement ce qui se passe dans votre magasin',
            'user-name'                   => 'Salut ! :user_name',
            'visitors'                    => 'Visiteur',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Créer une commande',
                'title'      => 'Commandes',

                'search-customer' => [
                    'create-btn'  => 'Créer un client',
                    'empty-info'  => 'Aucun client disponible pour ce terme de recherche.',
                    'empty-title' => 'Aucun client trouvé',
                    'search-by'   => 'Rechercher par email ou nom',
                    'title'       => 'Sélectionner un client',
                ],

                'datagrid' => [
                    'canceled'        => 'Annulée',
                    'channel-name'    => 'Canal',
                    'closed'          => 'Fermée',
                    'completed'       => 'Terminée',
                    'customer'        => 'Client',
                    'date'            => 'Date',
                    'email'           => 'E-mail',
                    'fraud'           => 'Fraude',
                    'grand-total'     => 'Total général',
                    'id'              => '#:id',
                    'items'           => 'Articles',
                    'location'        => 'Emplacement',
                    'order-id'        => 'ID de commande',
                    'pay-by'          => 'Payer par - :method',
                    'pay-via'         => 'Payer via',
                    'pending-payment' => 'Paiement en attente',
                    'pending'         => 'En attente',
                    'processing'      => 'En traitement',
                    'product-count'   => ':count + Plus de produits',
                    'status'          => 'Statut',
                    'success'         => 'Succès',
                    'view'            => 'Voir',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'Ajouter au panier',
                'back-btn'                => 'Retour',
                'check-billing-address'   => 'L\'adresse de facturation est manquante.',
                'check-shipping-address'  => 'L\'adresse de livraison est manquante.',
                'configuration'           => 'Configuration',
                'coupon-already-applied'  => 'Le code de coupon a déjà été appliqué.',
                'coupon-applied'          => 'Code de coupon appliqué avec succès.',
                'coupon-error'            => 'Impossible d\'appliquer le code de coupon.',
                'coupon-not-found'        => 'Coupon introuvable',
                'coupon-remove'           => 'Code de coupon supprimé avec succès.',
                'error'                   => 'Une erreur s\'est produite',
                'minimum-order-error'     => 'Le montant de la commande minimale n\'est pas atteint.',
                'order-placed-success'    => 'Commande passée avec succès.',
                'payment-not-supported'   => 'Ce mode de paiement n\'est pas pris en charge',
                'save-btn'                => 'Créer la commande',
                'specify-payment-method'  => 'Le mode de paiement est manquant.',
                'specify-shipping-method' => 'Le mode de livraison est manquant.',
                'title'                   => 'Créer une commande pour :name',

                'types' => [
                    'simple' => [
                        'none'         => 'Aucun',
                        'total-amount' => 'Montant total',
                    ],

                    'configurable' => [
                        'select-options' => 'Veuillez sélectionner une option',
                    ],

                    'bundle' => [
                        'none'         => 'Aucun',
                        'total-amount' => 'Montant total',
                    ],

                    'grouped' => [
                        'name' => 'Nom',
                    ],

                    'downloadable' => [
                        'title' => 'Liens',
                    ],

                    'virtual' => [
                        'none'         => 'Aucun',
                        'total-amount' => 'Montant total',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Produit ajouté au panier avec succès',
                    'success-remove'      => 'Article supprimé du panier avec succès',
                    'success-update'      => 'Article du panier mis à jour avec succès',

                    'items' => [
                        'add-product'       => 'Ajouter un produit',
                        'amount-per-unit'   => ':amount par unité x :qty quantité',
                        'delete'            => 'Supprimer',
                        'empty-description' => 'Aucun article trouvé dans votre panier.',
                        'empty-title'       => 'Panier vide',
                        'excl-tax'          => 'Hors taxe',
                        'move-to-wishlist'  => 'Déplacer vers la liste de souhaits',
                        'see-details'       => 'Voir les détails',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => 'Sous-total - :sub_total',
                        'title'             => 'Articles du panier',

                        'search' => [
                            'add-to-cart'   => 'Ajouter au panier',
                            'available-qty' => ':qty disponible',
                            'empty-info'    => 'Aucun produit disponible pour le terme de recherche.',
                            'empty-title'   => 'Aucun produit trouvé',
                            'product-image' => 'Image du produit',
                            'qty'           => 'Qté',
                            'sku'           => 'SKU - :sku',
                            'title'         => 'Rechercher des produits',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Ajouter une adresse',
                        'add-new'          => 'Ajouter une nouvelle adresse',
                        'add-new-address'  => 'Ajouter une nouvelle adresse',
                        'addresses'        => 'Adresses',
                        'back'             => 'Retour',
                        'billing-address'  => 'Adresse de facturation',
                        'city'             => 'Ville',
                        'company-name'     => 'Nom de l\'entreprise',
                        'confirm'          => 'Confirmer',
                        'country'          => 'Pays',
                        'edit-btn'         => 'Modifier l\'adresse',
                        'email'            => 'E-mail',
                        'first-name'       => 'Prénom',
                        'last-name'        => 'Nom de famille',
                        'postcode'         => 'Code postal',
                        'proceed'          => 'Continuer',
                        'same-as-billing'  => 'Utiliser la même adresse pour la livraison?',
                        'save'             => 'Enregistrer',
                        'save-address'     => 'Enregistrer dans le carnet d\'adresses',
                        'select-country'   => 'Sélectionner un pays',
                        'select-state'     => 'Sélectionner un état',
                        'shipping-address' => 'Adresse de livraison',
                        'state'            => 'État',
                        'street-address'   => 'Adresse',
                        'telephone'        => 'Téléphone',
                        'title'            => 'Adresse',
                        'vat-id'           => 'TVA',
                    ],

                    'payment' => [
                        'title' => 'Paiement',
                    ],

                    'shipping' => [
                        'title' => 'Livraison',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Appliquer le coupon',
                        'discount-amount'          => 'Montant de réduction',
                        'enter-your-code'          => 'Entrez votre code',
                        'grand-total'              => 'Total général',
                        'place-order'              => 'Passer la commande',
                        'processing'               => 'En cours de traitement',
                        'shipping-amount-excl-tax' => 'Frais de livraison (hors taxe)',
                        'shipping-amount-incl-tax' => 'Frais de livraison (taxe incluse)',
                        'shipping-amount'          => 'Montant de livraison',
                        'sub-total-excl-tax'       => 'Sous-total (hors taxe)',
                        'sub-total-incl-tax'       => 'Sous-total (taxe incluse)',
                        'sub-total'                => 'Sous-total',
                        'tax'                      => 'Taxe',
                        'title'                    => 'Résumé de la commande',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'Ajouter au panier',
                    'delete'            => 'Supprimer',
                    'empty-description' => 'Aucun article trouvé dans votre panier.',
                    'empty-title'       => 'Panier vide',
                    'excl-tax'          => 'Hors taxe : ',
                    'see-details'       => 'Voir les détails',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Articles du panier',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'Ajouter au panier',
                    'empty-description' => 'Aucun article trouvé dans vos commandes récentes.',
                    'empty-title'       => 'Commandes vides',
                    'see-details'       => 'Voir les détails',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Articles de commande récents',
                    'view'              => 'Voir',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'Ajouter au panier',
                    'delete'            => 'Supprimer',
                    'empty-description' => 'Aucun article trouvé dans votre liste de souhaits.',
                    'empty-title'       => 'Liste de souhaits vide',
                    'see-details'       => 'Voir les détails',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Articles de la liste de souhaits',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'Ajouter au panier',
                    'delete'            => 'Supprimer',
                    'empty-description' => 'Aucun article trouvé dans votre liste de comparaison.',
                    'empty-title'       => 'Liste de comparaison vide',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Articles de comparaison',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Par Unité x :qty Quantité',
                'billing-address'                => 'Adresse de facturation',
                'cancel'                         => 'Annuler',
                'cancel-msg'                     => 'Êtes-vous sûr de vouloir annuler cette commande',
                'cancel-success'                 => 'Commande annulée avec succès',
                'canceled'                       => 'Annulée',
                'channel'                        => 'Canal',
                'closed'                         => 'Fermée',
                'comment-success'                => 'Commentaire ajouté avec succès.',
                'comments'                       => 'Commentaires',
                'completed'                      => 'Terminée',
                'contact'                        => 'Contact',
                'create-success'                 => 'Commande créée avec succès',
                'currency'                       => 'Devise',
                'customer'                       => 'Client',
                'customer-group'                 => 'Groupe de clients',
                'customer-not-notified'          => ':date | Client <b>Non Notifié</b>',
                'customer-notified'              => ':date | Client <b>Notifié</b>',
                'discount'                       => 'Remise - :discount',
                'download-pdf'                   => 'Télécharger le PDF',
                'fraud'                          => 'Fraude',
                'grand-total'                    => 'Total Général - :grand_total',
                'invoice-id'                     => 'Facture #:invoice',
                'invoices'                       => 'Factures',
                'item-canceled'                  => 'Annulé (:qty_canceled)',
                'item-invoice'                   => 'Facturé (:qty_invoiced)',
                'item-ordered'                   => 'Commandé (:qty_ordered)',
                'item-refunded'                  => 'Remboursé (:qty_refunded)',
                'item-shipped'                   => 'Expédié (:qty_shipped)',
                'name'                           => 'Nom',
                'no-invoice-found'               => 'Aucune facture trouvée',
                'no-refund-found'                => 'Aucun remboursement trouvé',
                'no-shipment-found'              => 'Aucun envoi trouvé',
                'notify-customer'                => 'Notifier le client',
                'order-date'                     => 'Date de la commande',
                'order-information'              => 'Informations sur la commande',
                'order-status'                   => 'Statut de la commande',
                'payment-and-shipping'           => 'Paiement et Livraison',
                'payment-method'                 => 'Méthode de paiement',
                'pending'                        => 'En attente',
                'pending_payment'                => 'Paiement en attente',
                'per-unit'                       => 'Par Unité',
                'price'                          => 'Prix - :price',
                'price-excl-tax'                 => 'Prix (Hors Taxe) - :price',
                'price-incl-tax'                 => 'Prix (TTC) - :price',
                'processing'                     => 'En cours de traitement',
                'quantity'                       => 'Quantité',
                'refund'                         => 'Remboursement',
                'refund-id'                      => 'Remboursement #:refund',
                'refunded'                       => 'Remboursé',
                'reorder'                        => 'Recommander',
                'ship'                           => 'Expédier',
                'shipment'                       => 'Envoi #:shipment',
                'shipments'                      => 'Envois',
                'shipping-address'               => 'Adresse de livraison',
                'shipping-and-handling'          => 'Livraison et Manutention',
                'shipping-and-handling-excl-tax' => 'Livraison et Manutention (Hors Taxe)',
                'shipping-and-handling-incl-tax' => 'Livraison et Manutention (TTC)',
                'shipping-method'                => 'Méthode de livraison',
                'shipping-price'                 => 'Prix de livraison',
                'sku'                            => 'SKU - :sku',
                'status'                         => 'Statut',
                'sub-total'                      => 'Sous-total - :sub_total',
                'sub-total-excl-tax'             => 'Sous-total (Hors Taxe) - :sub_total',
                'sub-total-incl-tax'             => 'Sous-total (TTC) - :sub_total',
                'submit-comment'                 => 'Soumettre un commentaire',
                'summary-discount'               => 'Remise',
                'summary-grand-total'            => 'Total Général',
                'summary-sub-total'              => 'Sous-total',
                'summary-sub-total-excl-tax'     => 'Sous-total (Hors Taxe)',
                'summary-sub-total-incl-tax'     => 'Sous-total (TTC)',
                'summary-tax'                    => 'Taxe',
                'tax'                            => 'Taxe (:percent) - :tax',
                'title'                          => 'Commande #:order_id',
                'total-due'                      => 'Total à payer',
                'total-paid'                     => 'Total payé',
                'total-refund'                   => 'Total remboursé',
                'view'                           => 'Voir',
                'write-your-comment'             => 'Écrivez votre commentaire',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Expéditions',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Source d\'inventaire',
                    'order-date'       => 'Date de commande',
                    'order-id'         => 'ID de commande',
                    'shipment-date'    => 'Date d\'expédition',
                    'shipment-to'      => 'Destinataire de l\'expédition',
                    'total-qty'        => 'Quantité totale',
                    'view'             => 'Voir',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount par unité x :qty Quantité',
                'cancel-error'     => 'La commande ne peut pas être annulée',
                'carrier-name'     => 'Nom du transporteur',
                'create-btn'       => 'Créer une expédition',
                'creation-error'   => 'Erreur lors de la création de l\'expédition',
                'item-canceled'    => 'Annulé (:qty_canceled)',
                'item-invoice'     => 'Facturé (:qty_invoiced)',
                'item-ordered'     => 'Commandé (:qty_ordered)',
                'item-refunded'    => 'Remboursé (:qty_refunded)',
                'item-shipped'     => 'Expédié (:qty_shipped)',
                'order-error'      => 'L\'expédition n\'est pas valide',
                'per-unit'         => 'Par unité',
                'qty-available'    => 'Qté disponible',
                'qty-to-ship'      => 'Qté à expédier',
                'quantity-invalid' => 'Quantité invalide',
                'sku'              => 'SKU - :sku',
                'source'           => 'Source',
                'success'          => 'Expédition créée avec succès',
                'title'            => 'Créer une nouvelle expédition',
                'tracking-number'  => 'Numéro de suivi',
            ],

            'view' => [
                'billing-address'      => 'Adresse de facturation',
                'carrier-title'        => 'Titre du transporteur',
                'channel'              => 'Chaîne',
                'currency'             => 'Devise',
                'customer'             => 'Client',
                'email'                => 'E-mail - :email',
                'inventory-source'     => 'Source d\'inventaire',
                'order-date'           => 'Date de commande',
                'order-id'             => 'ID de commande',
                'order-information'    => 'Informations sur la commande',
                'order-status'         => 'Statut de la commande',
                'ordered-items'        => 'Articles commandés',
                'payment-and-shipping' => 'Paiement et expédition',
                'payment-method'       => 'Méthode de paiement',
                'product-image'        => 'Image du produit',
                'qty'                  => 'Quantité - :qty',
                'shipping-address'     => 'Adresse de livraison',
                'shipping-method'      => 'Méthode d\'expédition',
                'shipping-price'       => 'Frais d\'expédition',
                'sku'                  => 'SKU - :sku ',
                'title'                => 'Expédition n°:shipment_id',
                'tracking-number'      => 'Numéro de suivi',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Remboursements',

                'datagrid' => [
                    'billed-to'       => 'Facturé à',
                    'id'              => 'ID',
                    'order-id'        => 'ID de commande',
                    'refund-date'     => 'Date de remboursement',
                    'refunded-amount' => 'Montant Remboursé',
                    'view'            => 'Voir',
                ],
            ],

            'view' => [
                'account-information'        => 'Informations du compte',
                'adjustment-fee'             => 'Frais d\'ajustement',
                'adjustment-refund'          => 'Remboursement d\'ajustement',
                'base-discounted-amount'     => 'Montant réduit - :base_discounted_amount',
                'billing-address'            => 'Adresse de facturation',
                'currency'                   => 'Devise',
                'sub-total-amount-excl-tax'  => 'Sous-total (hors taxe) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Sous-total (taxe incluse) - :discounted_amount',
                'sub-total-amount'           => 'Sous-total - :discounted_amount',
                'grand-total'                => 'Total général',
                'order-channel'              => 'Canal de commande',
                'order-date'                 => 'Date de commande',
                'order-id'                   => 'ID de commande',
                'order-information'          => 'Informations sur la commande',
                'order-status'               => 'Statut de la commande',
                'payment-information'        => 'Informations de paiement',
                'payment-method'             => 'Méthode de paiement',
                'price-excl-tax'             => 'Prix (hors taxe) - :price',
                'price-incl-tax'             => 'Prix (taxe incluse) - :price',
                'price'                      => 'Prix - :price',
                'product-image'              => 'Image du produit',
                'product-ordered'            => 'Produits commandés',
                'qty'                        => 'Quantité - :qty',
                'refund'                     => 'Remboursement',
                'shipping-address'           => 'Adresse de livraison',
                'shipping-handling-excl-tax' => 'Expédition et manutention (hors taxe)',
                'shipping-handling-incl-tax' => 'Expédition et manutention (taxe incluse)',
                'shipping-handling'          => 'Expédition et manutention',
                'shipping-method'            => 'Méthode d\'expédition',
                'shipping-price'             => 'Frais d\'expédition',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => 'Sous-total (hors taxe)',
                'sub-total-incl-tax'         => 'Sous-total (taxe incluse)',
                'sub-total'                  => 'Sous-total',
                'tax'                        => 'Taxe',
                'tax-amount'                 => 'Montant de la taxe - :tax_amount',
                'title'                      => 'Remboursement #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Frais d’ajustement',
                'adjustment-refund'           => 'Remboursement d’ajustement',
                'amount-per-unit'             => ':amount par unité x :qty quantité',
                'create-success'              => 'Remboursement créé avec succès',
                'creation-error'              => 'La création de remboursement n\'est pas autorisée.',
                'discount-amount'             => 'Montant de réduction',
                'grand-total'                 => 'Total général',
                'invalid-qty'                 => 'Nous avons trouvé une quantité invalide pour facturer des articles.',
                'invalid-refund-amount-error' => 'Le montant du remboursement doit être non nul.',
                'item-canceled'               => 'Annulé (:qty_canceled)',
                'item-invoice'                => 'Facturé (:qty_invoiced)',
                'item-ordered'                => 'Commandé (:qty_ordered)',
                'item-refunded'               => 'Remboursé (:qty_refunded)',
                'item-shipped'                => 'Expédié (:qty_shipped)',
                'per-unit'                    => 'Par unité',
                'price'                       => 'Prix',
                'qty-to-refund'               => 'Quantité à rembourser',
                'refund-btn'                  => 'Rembourser',
                'refund-limit-error'          => 'Le montant du remboursement :amount ne peut pas être traité.',
                'refund-shipping'             => 'Remboursement de l’expédition',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => 'Sous-total',
                'tax-amount'                  => 'Montant de la taxe',
                'title'                       => 'Créer un remboursement',
                'update-totals-btn'           => 'Mettre à jour les totaux',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Factures',

                'datagrid' => [
                    'action'              => 'Actions',
                    'days-left'           => 'Il reste :count jour(s)',
                    'days-overdue'        => ':count jour(s) de retard',
                    'grand-total'         => 'Total général',
                    'id'                  => 'ID',
                    'invoice-date'        => 'Date de la facture',
                    'mass-update-success' => 'Factures sélectionnées mises à jour avec succès.',
                    'order-id'            => 'ID de la commande',
                    'overdue'             => 'En retard',
                    'overdue-by'          => 'En retard de :count jour(s)',
                    'paid'                => 'Payé',
                    'pending'             => 'En attente',
                    'status'              => 'Statut',
                    'update-status'       => 'Mettre à jour le statut',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Par Unité x :qty Quantité',
                'channel'                        => 'Canal',
                'customer-email'                 => 'Email - :email',
                'customer'                       => 'Client',
                'discount'                       => 'Montant de réduction - :discount',
                'email'                          => 'Email',
                'grand-total'                    => 'Total général',
                'invoice-items'                  => 'Articles de la facture',
                'invoice-sent'                   => 'Facture envoyée avec succès',
                'invoice-status'                 => 'Statut de la facture',
                'order-date'                     => 'Date de la commande',
                'order-id'                       => 'ID de la commande',
                'order-information'              => 'Informations sur la commande',
                'order-status'                   => 'Statut de la commande',
                'price-excl-tax'                 => 'Prix (Hors taxe) - :price',
                'price-incl-tax'                 => 'Prix (TTC) - :price',
                'price'                          => 'Prix - :price',
                'print'                          => 'Imprimer',
                'product-image'                  => 'Image du produit',
                'qty'                            => 'Quantité - :qty',
                'send-btn'                       => 'Envoyer',
                'send-duplicate-invoice'         => 'Envoyer une facture en double',
                'send'                           => 'Envoyer',
                'shipping-and-handling-excl-tax' => 'Frais de port et de manutention (Hors taxe)',
                'shipping-and-handling-incl-tax' => 'Frais de port et de manutention (TTC)',
                'shipping-and-handling'          => 'Frais de port et de manutention',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => 'Sous-total (Hors taxe) - :sub_total',
                'sub-total-incl-tax'             => 'Sous-total (TTC) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Sous-total (Hors taxe)',
                'sub-total-summary-incl-tax'     => 'Sous-total (TTC)',
                'sub-total-summary'              => 'Sous-total',
                'sub-total'                      => 'Sous-total - :sub_total',
                'summary-discount'               => 'Montant de réduction',
                'summary-tax'                    => 'Montant de taxe',
                'tax'                            => 'Montant de taxe - :tax',
                'title'                          => 'Facture #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount Par Unité x :qty Quantité',
                'create-invoice'     => 'Créer une Facture',
                'create-success'     => 'Facture créée avec succès',
                'create-transaction' => 'Créer une Transaction',
                'creation-error'     => 'La création de la facture de commande n\'est pas autorisée.',
                'invalid-qty'        => 'Nous avons trouvé une quantité invalide pour facturer les articles.',
                'invoice'            => 'Facture',
                'new-invoice'        => 'Nouvelle Facture',
                'product-error'      => 'Impossible de créer une facture sans produits.',
                'product-image'      => 'Image du Produit',
                'qty-to-invoiced'    => 'Quantité à facturer',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Coordonnées bancaires',
                'bill-to'                    => 'Facturé à',
                'contact-number'             => 'Numéro de contact',
                'contact'                    => 'Contact',
                'date'                       => 'Date de la facture',
                'discount'                   => 'Remise',
                'excl-tax'                   => 'Hors taxe:',
                'grand-total'                => 'Total général',
                'invoice-id'                 => 'ID de la facture',
                'invoice'                    => 'Facture',
                'order-date'                 => 'Date de la commande',
                'order-id'                   => 'ID de la commande',
                'payment-method'             => 'Méthode de paiement',
                'payment-terms'              => 'Conditions de paiement',
                'price'                      => 'Prix',
                'product-name'               => 'Nom du produit',
                'qty'                        => 'Quantité',
                'ship-to'                    => 'Expédier à',
                'shipping-handling-excl-tax' => 'Frais de port et de manutention (Hors taxe)',
                'shipping-handling-incl-tax' => 'Frais de port et de manutention (TTC)',
                'shipping-handling'          => 'Frais de port et de manutention',
                'shipping-method'            => 'Méthode d\'expédition',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => 'Sous-total (Hors taxe)',
                'subtotal-incl-tax'          => 'Sous-total (TTC)',
                'subtotal'                   => 'Sous-total',
                'tax-amount'                 => 'Montant de la taxe',
                'tax'                        => 'Taxe',
                'vat-number'                 => 'Numéro de TVA',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Date de la transaction',
            'transaction-id'   => 'ID de la transaction',
            'view'             => 'Voir',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => 'Créer des transactions',
                'title'      => 'Transactions',

                'datagrid' => [
                    'completed'          => 'Terminé',
                    'id'                 => 'ID',
                    'invoice-id'         => 'ID de facture',
                    'order-id'           => 'ID de commande',
                    'paid'               => 'Payé',
                    'pending'            => 'En attente',
                    'status'             => 'Statut',
                    'transaction-amount' => 'Montant',
                    'transaction-date'   => 'Date',
                    'transaction-id'     => 'ID de transaction',
                    'view'               => 'Voir',
                ],

                'create' => [
                    'already-paid'               => 'Déjà payé',
                    'amount'                     => 'Montant',
                    'create-transaction'         => 'Créer une transaction',
                    'invoice-id'                 => 'ID de la facture',
                    'invoice-missing'            => 'Facture manquante',
                    'payment-method'             => 'Méthode de paiement',
                    'save-transaction'           => 'Enregistrer la transaction',
                    'transaction-amount-exceeds' => 'Le montant de la transaction dépasse',
                    'transaction-amount-zero'    => 'Montant de la transaction nul',
                    'transaction-saved'          => 'Transaction enregistrée avec succès.',
                ],

                'view' => [
                    'amount'           => 'Montant',
                    'created-at'       => 'Créé le',
                    'invoice-id'       => 'Numéro de Facture',
                    'order-id'         => 'Numéro de Commande',
                    'payment-details'  => 'Détails de Paiement',
                    'payment-method'   => 'Méthode de Paiement',
                    'status'           => 'Statut',
                    'title'            => 'Détails de la Transaction',
                    'transaction-id'   => 'Identifiant de la Transaction',
                ],
            ],
        ],

        'booking' => [
            'index' => [
                'datagrid' => [
                    'created-date' => 'Date de création',
                    'from'         => 'De',
                    'id'           => 'ID',
                    'order-id'     => 'ID de commande',
                    'qty'          => 'Quantité',
                    'to'           => 'À',
                    'view'         => 'Voir',
                ],

                'title'    => 'Réservations',
            ],

            'calendar' => [
                'booking-date'     => 'Date de réservation',
                'booking-details'  => 'Détails de la réservation',
                'canceled'         => 'Annulé',
                'closed'           => 'Fermé',
                'done'             => 'Terminé',
                'order-id'         => 'ID de commande',
                'pending'          => 'En attente',
                'price'            => 'Prix',
                'status'           => 'Statut',
                'time-slot'        => 'Créneau horaire:',
                'view-details'     => 'Voir les détails',
            ],

            'title' => 'Produits réservés',
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => 'Le :name a déjà été pris.',
                'create-btn'    => 'Créer un produit',
                'title'         => 'Produits',

                'create' => [
                    'back-btn'                => 'Retour',
                    'configurable-attributes' => 'Attributs configurables',
                    'create-btn'              => 'Créer un produit',
                    'family'                  => 'Famille',
                    'save-btn'                => 'Enregistrer le produit',
                    'sku'                     => 'SKU',
                    'title'                   => 'Créer un nouveau produit',
                    'type'                    => 'Type',
                ],

                'datagrid' => [
                    'active'                 => 'Actif',
                    'attribute-family'       => 'Famille d\'attributs',
                    'attribute-family-value' => 'Famille d\'attributs - :attribute_family',
                    'category'               => 'Catégorie',
                    'channel'                => 'Chaîne',
                    'copy-of'                => 'Copie de :value',
                    'copy-of-slug'           => 'copie-de-:value',
                    'delete'                 => 'Supprimer',
                    'disable'                => 'Désactiver',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => 'Image',
                    'mass-delete-success'    => 'Produits sélectionnés supprimés avec succès',
                    'mass-update-success'    => 'Produits sélectionnés mis à jour avec succès',
                    'name'                   => 'Nom',
                    'out-of-stock'           => 'En rupture de stock',
                    'price'                  => 'Prix',
                    'product-image'          => 'Image du produit',
                    'qty'                    => 'Quantité',
                    'qty-value'              => ':qty disponible(s)',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => 'Statut',
                    'type'                   => 'Type',
                    'update-status'          => 'Mettre à jour le statut',
                ],
            ],

            'edit' => [
                'preview'  => 'Aperçu',
                'remove'   => 'Supprimer',
                'save-btn' => 'Enregistrer le produit',
                'title'    => 'Modifier le produit',

                'channels' => [
                    'title' => 'Canaux',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Ajouter un prix de groupe',
                        'all-groups'                => 'Tous les groupes',
                        'create-btn'                => 'Ajouter un nouveau',
                        'discount-group-price-info' => 'Pour :qty quantité à un rabais de :price',
                        'edit-btn'                  => 'Modifier',
                        'empty-info'                => 'Tarification spéciale pour les clients appartenant à un groupe spécifique.',
                        'fixed-group-price-info'    => 'Pour :qty quantité à un prix fixe de :price',
                        'title'                     => 'Prix de groupe client',

                        'create' => [
                            'all-groups'     => 'Tous les groupes',
                            'create-title'   => 'Créer un prix de groupe client',
                            'customer-group' => 'Groupe client',
                            'delete-btn'     => 'Supprimer',
                            'discount'       => 'Remise',
                            'fixed'          => 'Fixe',
                            'price'          => 'Prix',
                            'price-type'     => 'Type de prix',
                            'qty'            => 'Quantité minimale',
                            'save-btn'       => 'Enregistrer',
                            'update-title'   => 'Mettre à jour le prix de groupe client',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Quantité commandée en attente : :qty',
                    'pending-ordered-qty-info' => 'La quantité en attente de commande sera déduite de la source d\'inventaire respective après l\'expédition. En cas d\'annulation, la quantité en attente sera disponible à la vente.',
                    'title'                    => 'Inventaires',
                ],

                'categories' => [
                    'title' => 'Catégories',
                ],

                'images' => [
                    'info'  => 'La résolution de l\'image devrait être de 560px X 609px',
                    'title' => 'Images',
                ],

                'videos' => [
                    'error' => 'Erreur : La taille de :attribute ne doit pas dépasser :max kilo-octets. Veuillez choisir un fichier plus petit.',
                    'info'  => 'La taille maximale de la vidéo doit être d\'environ :size',
                    'title' => 'Vidéos',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Ajoutez des produits connexes en un clin d\'œil.',
                        'info'       => 'En plus du produit que le client consulte, des produits connexes lui sont présentés.',
                        'title'      => 'Produits connexes',
                    ],

                    'up-sells' => [
                        'empty-info' => 'Ajoutez des produits de vente supérieure en un clin d\'œil.',
                        'info'       => 'Le client se voit proposer des produits de vente supérieure, qui servent d\'alternative premium ou de meilleure qualité au produit qu\'il consulte actuellement.',
                        'title'      => 'Produits de vente supérieure',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Ajoutez des produits de vente croisée en un clin d\'œil.',
                        'info'       => 'À côté du panier d\'achat, vous trouverez ces produits "achat impulsif" positionnés en tant que produits de vente croisée pour compléter les articles déjà ajoutés à votre panier.',
                        'title'      => 'Produits de vente croisée',
                    ],

                    'add-btn'           => 'Ajouter un produit',
                    'delete'            => 'Supprimer',
                    'empty-info'        => 'Pour ajouter des produits de type :type en un clin d\'œil.',
                    'empty-title'       => 'Ajouter un produit',
                    'image-placeholder' => 'Image du produit',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'simple' => [
                        'customizable-options' => [
                            'add-btn'           => 'Ajouter une option',
                            'empty-info'        => 'Pour créer des options personnalisables rapidement.',
                            'empty-title'       => 'Ajouter une option',
                            'info'              => 'Cela personnalisera le produit simple.',
                            'title'             => 'Article personnalisable',

                            'update-create' => [
                                'is-required'               => 'Est requis',
                                'max-characters'            => 'Nombre maximum de caractères',
                                'name'                      => 'Titre',
                                'no'                        => 'Non',
                                'price'                     => 'Prix',
                                'save-btn'                  => 'Enregistrer',
                                'supported-file-extensions' => 'Extensions de fichier prises en charge',
                                'title'                     => 'Option',
                                'type'                      => 'Type',
                                'yes'                       => 'Oui',
                            ],

                            'option' => [
                                'add-btn'     => 'Ajouter une option',
                                'delete'      => 'Supprimer',
                                'delete-btn'  => 'Supprimer',
                                'edit-btn'    => 'Modifier',
                                'empty-info'  => 'Pour créer diverses combinaisons de produits rapidement.',
                                'empty-title' => 'Ajouter une option',

                                'types' => [
                                    'text' => [
                                        'title' => 'Texte',
                                    ],

                                    'textarea' => [
                                        'title' => 'Zone de texte',
                                    ],

                                    'checkbox' => [
                                        'title' => 'Case à cocher',
                                    ],

                                    'radio' => [
                                        'title' => 'Bouton radio',
                                    ],

                                    'select' => [
                                        'title' => 'Sélectionner',
                                    ],

                                    'multiselect' => [
                                        'title' => 'Sélection multiple',
                                    ],

                                    'date' => [
                                        'title' => 'Date',
                                    ],

                                    'datetime' => [
                                        'title' => 'Date et heure',
                                    ],

                                    'time' => [
                                        'title' => 'Heure',
                                    ],

                                    'file' => [
                                        'title' => 'Fichier',
                                    ],
                                ],

                                'items' => [
                                    'update-create' => [
                                        'label'    => 'Étiquette',
                                        'price'    => 'Prix',
                                        'save-btn' => 'Enregistrer',
                                        'title'    => 'Option',
                                    ],
                                ],
                            ],

                            'validations' => [
                                'associated-product' => 'Le produit est déjà associé à un produit configurable, groupé ou en pack.',
                            ],
                        ],
                    ],

                    'configurable' => [
                        'add-btn'           => 'Ajouter une variante',
                        'delete-btn'        => 'Supprimer',
                        'edit-btn'          => 'Modifier',
                        'empty-info'        => 'Pour créer diverses combinaisons de produits en un clin d\'œil.',
                        'empty-title'       => 'Ajouter une variante',
                        'image-placeholder' => 'Image du produit',
                        'info'              => 'Les produits de variation dépendent de toutes les combinaisons possibles d\'attributs.',
                        'qty'               => ':qty quantité',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Variantes',

                        'create' => [
                            'description'            => 'Description',
                            'name'                   => 'Nom',
                            'save-btn'               => 'Ajouter',
                            'title'                  => 'Ajouter une variante',
                            'variant-already-exists' => 'Cette variante existe déjà',
                        ],

                        'edit' => [
                            'disabled'        => 'Désactivé',
                            'edit-info'       => 'Si vous souhaitez mettre à jour les informations détaillées du produit, rendez-vous sur la',
                            'edit-link-title' => 'Page de détails du produit',
                            'enabled'         => 'Activé',
                            'images'          => 'Images',
                            'name'            => 'Nom',
                            'price'           => 'Prix',
                            'quantities'      => 'Quantités',
                            'save-btn'        => 'Enregistrer',
                            'sku'             => 'SKU',
                            'status'          => 'Statut',
                            'title'           => 'Produit',
                            'weight'          => 'Poids',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Ajouter des images',
                            'apply-to-all-btn'    => 'Appliquer à tous',
                            'apply-to-all-name'   => 'Appliquer un nom à toutes les variantes.',
                            'apply-to-all-sku'    => 'Appliquer un prix à toutes les références.',
                            'apply-to-all-status' => 'Appliquer un statut à toutes les variantes.',
                            'apply-to-all-weight' => 'Appliquer un poids à toutes les variantes.',
                            'edit-inventories'    => 'Modifier les inventaires',
                            'edit-names'          => 'Modifier les noms',
                            'edit-prices'         => 'Modifier les prix',
                            'edit-sku'            => 'Modifier la référence',
                            'edit-status'         => 'Modifier le statut',
                            'edit-weight'         => 'Modifier le poids',
                            'name'                => 'Nom',
                            'price'               => 'Prix',
                            'remove-images'       => 'Supprimer les images',
                            'remove-variants'     => 'Supprimer les variantes',
                            'select-action'       => 'Sélectionner une action',
                            'select-variants'     => 'Sélectionner les variantes',
                            'status'              => 'Statut',
                            'variant-name'        => 'Nom de la variante',
                            'variant-sku'         => 'Référence de la variante',
                            'weight'              => 'Poids',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Ajouter un produit',
                        'default-qty'       => 'Quantité par défaut',
                        'delete'            => 'Supprimer',
                        'empty-info'        => 'Pour créer diverses combinaisons de produits en un clin d\'œil.',
                        'empty-title'       => 'Ajouter un produit',
                        'image-placeholder' => 'Image du produit',
                        'info'              => 'Un produit groupé comprend des articles autonomes présentés sous forme d\'ensemble, permettant des variations ou une coordination par saison ou par thème. Chaque produit peut être acheté individuellement ou en tant que partie du groupe.',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Produits groupés',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Ajouter une option',
                        'empty-info'        => 'Pour créer des options de bundle en un clin d\'œil.',
                        'empty-title'       => 'Ajouter une option',
                        'image-placeholder' => 'Image du produit',
                        'info'              => 'Un produit bundle est un ensemble de plusieurs articles ou services vendus ensemble à un prix spécial, offrant une valeur et une commodité aux clients.',
                        'title'             => 'Articles de bundle',

                        'update-create' => [
                            'checkbox'    => 'Case à cocher',
                            'is-required' => 'Obligatoire',
                            'multiselect' => 'Sélection multiple',
                            'name'        => 'Titre',
                            'no'          => 'Non',
                            'radio'       => 'Radio',
                            'save-btn'    => 'Enregistrer',
                            'select'      => 'Sélectionner',
                            'title'       => 'Option',
                            'type'        => 'Type',
                            'yes'         => 'Oui',
                        ],

                        'option' => [
                            'add-btn'     => 'Ajouter un produit',
                            'default-qty' => 'Quantité par défaut',
                            'delete'      => 'Supprimer',
                            'delete-btn'  => 'Supprimer',
                            'edit-btn'    => 'Modifier',
                            'empty-info'  => 'Pour créer diverses combinaisons de produits en un clin d\'œil.',
                            'empty-title' => 'Ajouter un produit',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Définissez le produit par défaut à l\'aide de la case à cocher',
                                    'title' => 'Case à cocher',
                                ],

                                'multiselect' => [
                                    'info'  => 'Définissez le produit par défaut à l\'aide du bouton de case à cocher',
                                    'title' => 'Sélection multiple',
                                ],

                                'radio' => [
                                    'info'  => 'Définissez le produit par défaut à l\'aide du bouton radio',
                                    'title' => 'Radio',
                                ],

                                'select' => [
                                    'info'  => 'Définissez le produit par défaut à l\'aide du bouton radio',
                                    'title' => 'Sélectionner',
                                ],
                            ],
                        ],
                    ],

                    'booking' => [
                        'available-from' => 'Disponible à partir de',
                        'available-to'   => 'Disponible jusqu\'à',
                        'location'       => 'Emplacement',
                        'qty'            => 'Quantité',
                        'title'          => 'Type de réservation',

                        'available-every-week' => [
                            'no'    => 'Non',
                            'title' => 'Disponible chaque semaine',
                            'yes'   => 'Oui',
                        ],

                        'appointment' => [
                            'break-duration' => 'Temps de pause entre les créneaux (minutes)',
                            'slot-duration'  => 'Durée du créneau (minutes)',

                            'same-slot-for-all-days' => [
                                'no'    => 'Non',
                                'title' => 'Même créneau pour tous les jours',
                                'yes'   => 'Oui',
                            ],
                        ],

                        'default' => [
                            'add'              => 'Ajouter',
                            'break-duration'   => 'Temps de pause entre les créneaux (minutes)',
                            'close'            => 'Fermer',
                            'description'      => 'Informations sur la réservation',
                            'description-info' => 'La durée sera créée et affichée en fonction des créneaux. Elle sera unique à travers tous les créneaux et visible sur la vitrine du magasin',
                            'edit'             => 'Modifier',
                            'many'             => 'Plusieurs réservations pour un jour',
                            'one'              => 'Une réservation pour plusieurs jours',
                            'open'             => 'Ouvrir',
                            'slot-add'         => 'Ajouter des créneaux',
                            'slot-duration'    => 'Durée du créneau (minutes)',
                            'slot-title'       => 'Durée des créneaux',
                            'title'            => 'Par défaut',
                            'unavailable'      => 'Indisponible',

                            'modal'            => [
                                'slot' => [
                                    'add-title'  => 'Ajouter des créneaux',
                                    'close'      => 'Fermer',
                                    'day'        => 'Jour',
                                    'edit-title' => 'Modifier les créneaux',
                                    'friday'     => 'Vendredi',
                                    'from'       => 'De',
                                    'from-day'   => 'Du jour',
                                    'from-time'  => 'De l\'heure',
                                    'monday'     => 'Lundi',
                                    'open'       => 'Ouvrir',
                                    'saturday'   => 'Samedi',
                                    'save'       => 'Enregistrer',
                                    'select'     => 'Sélectionner',
                                    'status'     => 'Statut',
                                    'sunday'     => 'Dimanche',
                                    'thursday'   => 'Jeudi',
                                    'to'         => 'À',
                                    'to-day'     => 'Au jour',
                                    'to-time'    => 'À l\'heure',
                                    'tuesday'    => 'Mardi',
                                    'wednesday'  => 'Mercredi',
                                    'week'       => ':day',
                                ],
                            ],
                        ],

                        'event' => [
                            'add'                => 'Ajouter des billets',
                            'delete'             => 'Supprimer',
                            'description'        => 'Description',
                            'description-info'   => 'Aucun billet disponible.',
                            'edit'               => 'Modifier',
                            'name'               => 'Nom',
                            'price'              => 'Prix',
                            'qty'                => 'Quantité',
                            'special-price'      => 'Prix spécial',
                            'special-price-from' => 'Prix spécial à partir de',
                            'special-price-to'   => 'Prix spécial jusqu\'à',
                            'title'              => 'Billets',
                            'valid-from'         => 'Valide à partir de',
                            'valid-until'        => 'Valide jusqu\'à',

                            'modal'              => [
                                'edit' => 'Modifier les billets',
                                'save' => 'Enregistrer',
                            ],
                        ],

                        'empty-info' => [
                            'tickets' => [
                                'add' => 'Ajouter des billets',
                            ],

                            'slots'   => [
                                'add'         => 'Ajouter des créneaux',
                                'description' => 'Créneaux disponibles avec durée.',
                            ],
                        ],

                        'rental' => [
                            'daily'                  => 'Base quotidienne',
                            'daily-hourly'           => 'Les deux (quotidienne et horaire)',
                            'daily-price'            => 'Prix quotidien',
                            'hourly'                 => 'Base horaire',
                            'hourly-price'           => 'Prix horaire',
                            'title'                  => 'Type de location',

                            'same-slot-for-all-days' => [
                                'no'    => 'Non',
                                'title' => 'Même créneau pour tous les jours',
                                'yes'   => 'Oui',
                            ],
                        ],

                        'slots' => [
                            'add'              => 'Ajouter des créneaux',
                            'description-info' => 'La durée sera créée et affichée en fonction des créneaux. Elle sera unique à travers tous les créneaux et visible sur la vitrine du magasin',
                            'save'             => 'Enregistrer',
                            'title'            => 'Durée des créneaux',
                            'unavailable'      => 'Indisponible',

                            'action'           => [
                                'add' => 'Ajouter',
                            ],

                            'modal'            => [
                                'slot' => [
                                    'friday'     => 'Vendredi',
                                    'from'       => 'De',
                                    'monday'     => 'Lundi',
                                    'saturday'   => 'Samedi',
                                    'sunday'     => 'Dimanche',
                                    'thursday'   => 'Jeudi',
                                    'to'         => 'À',
                                    'tuesday'    => 'Mardi',
                                    'wednesday'  => 'Mercredi',
                                ],
                            ],
                        ],

                        'table' => [
                            'break-duration'            => 'Temps de pause entre les créneaux (minutes)',
                            'guest-capacity'            => 'Capacité d\'invités',
                            'guest-limit'               => 'Limite d\'invités par table',
                            'prevent-scheduling-before' => 'Empêcher la planification avant',
                            'slot-duration'             => 'Durée du créneau (minutes)',

                            'charged-per'               => [
                                'guest'  => 'Invité',
                                'table'  => 'Table',
                                'title'  => 'Facturé par',
                            ],

                            'same-slot-for-all-days'    => [
                                'no'    => 'Non',
                                'title' => 'Même créneau pour tous les jours',
                                'yes'   => 'Oui',
                            ],
                        ],

                        'type' => [
                            'appointment' => 'Réservation de rendez-vous',
                            'default'     => 'Réservation par défaut',
                            'event'       => 'Réservation d\'événement',
                            'many'        => 'Plusieurs',
                            'one'         => 'Un',
                            'rental'      => 'Réservation de location',
                            'table'       => 'Réservation de table',
                            'title'       => 'Type',
                        ],

                        'validations' => [
                            'type-mismatch'      => 'Le type de réservation ne peut pas être modifié.',
                            'time-validation'    => "L'heure de début doit être inférieure à l'heure de fin.",
                            'overlap-validation' => 'Le créneau horaire chevauche un créneau existant.',
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Ajouter un lien',
                            'delete-btn'  => 'Supprimer',
                            'edit-btn'    => 'Modifier',
                            'empty-info'  => 'Pour créer un lien en un clin d\'œil.',
                            'empty-title' => 'Ajouter un lien',
                            'file'        => 'Fichier : ',
                            'info'        => 'Le type de produit téléchargeable permet de vendre des produits numériques tels que des livres électroniques, des applications logicielles, de la musique, des jeux, etc.',
                            'sample-file' => 'Fichier d\'exemple : ',
                            'sample-url'  => 'URL de l\'exemple : ',
                            'title'       => 'Liens téléchargeables',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'downloads'   => 'Téléchargement autorisé',
                                'file'        => 'Fichier',
                                'file-type'   => 'Type de fichier',
                                'name'        => 'Titre',
                                'price'       => 'Prix',
                                'sample'      => 'Échantillon',
                                'sample-type' => 'Type d\'échantillon',
                                'save-btn'    => 'Enregistrer',
                                'title'       => 'Lien',
                                'url'         => 'URL : ',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Ajouter un échantillon',
                            'delete-btn'  => 'Supprimer',
                            'edit-btn'    => 'Modifier',
                            'empty-info'  => 'Pour créer un échantillon en un clin d\'œil.',
                            'empty-title' => 'Ajouter un échantillon',
                            'file'        => 'Fichier : ',
                            'info'        => 'Le type de produit téléchargeable permet de vendre des produits numériques tels que des livres électroniques, des applications logicielles, de la musique, des jeux, etc.',
                            'title'       => 'Échantillons téléchargeables',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'file'        => 'Fichier',
                                'file-type'   => 'Type de fichier',
                                'name'        => 'Titre',
                                'save-btn'    => 'Enregistrer',
                                'title'       => 'Lien',
                                'url'         => 'URL : ',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Produit créé avec succès',
            'delete-failed'           => 'Échec de la suppression du produit',
            'delete-success'          => 'Produit supprimé avec succès',
            'product-copied'          => 'Produit copié avec succès',
            'saved-inventory-message' => 'Produit enregistré avec succès',
            'update-success'          => 'Produit mis à jour avec succès',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Créer des attributs',
                'title'      => 'Attributs',

                'datagrid' => [
                    'boolean'             => 'Booléen',
                    'channel-based'       => 'Basé sur le canal',
                    'checkbox'            => 'Case à cocher',
                    'code'                => 'Code',
                    'created-at'          => 'Créé à',
                    'date'                => 'Date',
                    'date-time'           => 'Date et heure',
                    'delete'              => 'Supprimer',
                    'edit'                => 'Éditer',
                    'false'               => 'Faux',
                    'file'                => 'Fichier',
                    'id'                  => 'ID',
                    'image'               => 'Image',
                    'locale-based'        => 'Basé sur la langue',
                    'mass-delete-success' => 'Attribut sélectionné supprimé avec succès',
                    'multiselect'         => 'Sélection multiple',
                    'name'                => 'Nom',
                    'price'               => 'Prix',
                    'required'            => 'Requis',
                    'select'              => 'Sélectionner',
                    'text'                => 'Texte',
                    'textarea'            => 'Zone de texte',
                    'true'                => 'Vrai',
                    'type'                => 'Type',
                    'unique'              => 'Unique',
                ],
            ],

            'create' => [
                'add-attribute-options' => 'Ajouter des options d\'attributs',
                'add-option'            => 'Ajouter une option',
                'add-options-info'      => 'Pour créer diverses combinaisons d\'options d\'attributs en une seule fois.',
                'add-row'               => 'Ajouter une ligne',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nom de l\'administrateur',
                'back-btn'              => 'Retour',
                'boolean'               => 'Booléen',
                'checkbox'              => 'Case à cocher',
                'code'                  => 'Code d\'attribut',
                'color'                 => 'Couleur',
                'configuration'         => 'Configuration',
                'create-empty-option'   => 'Créer une option vide par défaut',
                'date'                  => 'Date',
                'datetime'              => 'Date et heure',
                'decimal'               => 'Décimal',
                'default-value'         => 'Valeur par défaut',
                'email'                 => 'E-mail',
                'enable-wysiwyg'        => 'Activer l\'éditeur WYSIWYG',
                'file'                  => 'Fichier',
                'general'               => 'Général',
                'image'                 => 'Image',
                'input-options'         => 'Options d\'entrée',
                'input-validation'      => 'Validation de l\'entrée',
                'is-comparable'         => 'L\'attribut est comparable',
                'is-configurable'       => 'Utiliser pour créer un produit configurable',
                'is-filterable'         => 'Utiliser dans la navigation en couches',
                'is-required'           => 'Est requis',
                'is-unique'             => 'Est unique',
                'is-visible-on-front'   => 'Visible sur la page de visualisation du produit en frontend',
                'label'                 => 'Étiquette',
                'multiselect'           => 'Sélection multiple',
                'no'                    => 'Non',
                'numeric'               => 'Nombre',
                'option-deleted'        => 'Option supprimée avec succès',
                'options'               => 'Possibilités',
                'position'              => 'Position',
                'price'                 => 'Prix',
                'regex'                 => 'Regex',
                'regex-info'            => 'L\'expression doit être entre guillemets doubles.',
                'save-btn'              => 'Enregistrer l\'attribut',
                'select'                => 'Sélectionner',
                'select-type'           => 'Sélectionner le type d\'attribut',
                'swatch'                => 'Puce',
                'text'                  => 'Texte',
                'textarea'              => 'Zone de texte',
                'title'                 => 'Ajouter un attribut',
                'type'                  => 'Type d\'attribut',
                'url'                   => 'URL',
                'use-in-flat'           => 'Créer dans la table des produits plats',
                'validations'           => 'Validations',
                'value-per-channel'     => 'Valeur par canal',
                'value-per-locale'      => 'Valeur par localisation',
                'yes'                   => 'Oui',

                'option' => [
                    'color'    => 'Nuancier de couleurs',
                    'dropdown' => 'Menu déroulant',
                    'image'    => 'Nuancier d\'images',
                    'save-btn' => 'Enregistrer l\'option',
                    'text'     => 'Nuancier de texte',
                ],
            ],

            'edit' => [
                'add-attribute-options' => 'Ajouter des options d\'attributs',
                'add-option'            => 'Ajouter une option',
                'add-options-info'      => 'Pour créer diverses combinaisons d\'options d\'attributs en une seule fois.',
                'add-row'               => 'Ajouter une ligne',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nom de l\'administrateur',
                'back-btn'              => 'Retour',
                'boolean'               => 'Booléen',
                'checkbox'              => 'Case à cocher',
                'code'                  => 'Code d\'attribut',
                'color'                 => 'Couleur',
                'configuration'         => 'Configuration',
                'create-empty-option'   => 'Créer une option vide par défaut',
                'date'                  => 'Date',
                'datetime'              => 'Date et heure',
                'decimal'               => 'Décimal',
                'default-value'         => 'Valeur par défaut',
                'email'                 => 'E-mail',
                'enable-wysiwyg'        => 'Activer l\'éditeur WYSIWYG',
                'file'                  => 'Fichier',
                'general'               => 'Général',
                'image'                 => 'Image',
                'input-options'         => 'Options d\'entrée',
                'input-validation'      => 'Validation de l\'entrée',
                'is-comparable'         => 'L\'attribut est comparable',
                'is-configurable'       => 'Utiliser pour créer un produit configurable',
                'is-filterable'         => 'Utiliser dans la navigation en couches',
                'is-required'           => 'Est requis',
                'is-unique'             => 'Est unique',
                'is-visible-on-front'   => 'Visible sur la page de visualisation du produit en frontend',
                'label'                 => 'Étiquette',
                'multiselect'           => 'Sélection multiple',
                'no'                    => 'Non',
                'numeric'               => 'Nombre',
                'option-deleted'        => 'Option supprimée avec succès',
                'options'               => 'Possibilités',
                'position'              => 'Position',
                'price'                 => 'Prix',
                'regex'                 => 'Regex',
                'regex-info'            => 'L\'expression doit être entre guillemets doubles.',
                'save-btn'              => 'Enregistrer l\'attribut',
                'select'                => 'Sélectionner',
                'select-type'           => 'Sélectionner le type d\'attribut',
                'swatch'                => 'Puce',
                'text'                  => 'Texte',
                'textarea'              => 'Zone de texte',
                'title'                 => 'Modifier l\'attribut',
                'type'                  => 'Type d\'attribut',
                'url'                   => 'URL',
                'use-in-flat'           => 'Créer dans la table des produits plats',
                'validations'           => 'Validations',
                'value-per-channel'     => 'Valeur par canal',
                'value-per-locale'      => 'Valeur par localisation',
                'yes'                   => 'Oui',

                'option' => [
                    'color'    => 'Nuancier de couleurs',
                    'dropdown' => 'Menu déroulant',
                    'image'    => 'Nuancier d\'images',
                    'save-btn' => 'Enregistrer l\'option',
                    'text'     => 'Nuancier de texte',
                ],
            ],

            'create-success'    => 'Attribut créé avec succès',
            'delete-failed'     => 'Échec de la suppression de l\'attribut',
            'delete-success'    => 'Attribut supprimé avec succès',
            'update-success'    => 'Attribut mis à jour avec succès',
            'user-define-error' => 'Impossible de supprimer l\'attribut système',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'Créer une catégorie',
                'title'   => 'Catégories',

                'datagrid' => [
                    'active'         => 'Actif',
                    'delete'         => 'Supprimer',
                    'delete-success' => ':resource sélectionnées ont été supprimées avec succès',
                    'edit'           => 'Modifier',
                    'id'             => 'ID',
                    'inactive'       => 'Inactif',
                    'name'           => 'Nom',
                    'no-of-products' => 'Visible dans le menu',
                    'position'       => 'Position',
                    'status'         => 'Statut',
                    'update-status'  => 'Mettre à jour le statut',
                ],
            ],

            'create' => [
                'add-banner'               => 'Ajouter une bannière',
                'add-logo'                 => 'Ajouter un logo',
                'back-btn'                 => 'Retour',
                'banner'                   => 'Bannière',
                'banner-size'              => 'Format de bannière (1320px X 300px)',
                'description'              => 'Description',
                'description-and-images'   => 'Description et images',
                'description-only'         => 'Description uniquement',
                'display-mode'             => 'Mode d\'affichage',
                'enter-position'           => 'Entrer la position',
                'filterable-attributes'    => 'Attributs filtrables',
                'general'                  => 'Général',
                'logo'                     => 'Logo',
                'logo-size'                => 'Résolution du logo doit être (110px X 110px)',
                'meta-description'         => 'Méta-description',
                'meta-keywords'            => 'Méta-mots-clés',
                'meta-title'               => 'Méta-titre',
                'name'                     => 'Nom',
                'parent-category'          => 'Catégorie parente',
                'position'                 => 'Position',
                'products-and-description' => 'Produits et description',
                'products-only'            => 'Produits uniquement',
                'save-btn'                 => 'Enregistrer la catégorie',
                'select-display-mode'      => 'Sélectionner le mode d\'affichage',
                'seo-details'              => 'Détails SEO',
                'settings'                 => 'Paramètres',
                'slug'                     => 'Slug',
                'title'                    => 'Ajouter une nouvelle catégorie',
                'visible-in-menu'          => 'Visible dans le menu',
            ],

            'edit' => [
                'add-banner'               => 'Ajouter une bannière',
                'add-logo'                 => 'Ajouter un logo',
                'back-btn'                 => 'Retour',
                'banner'                   => 'Bannière',
                'banner-size'              => 'Format de bannière (1320px X 300px)',
                'description'              => 'Description',
                'description-and-images'   => 'Description et images',
                'description-only'         => 'Description uniquement',
                'display-mode'             => 'Mode d\'affichage',
                'enter-position'           => 'Entrer la position',
                'filterable-attributes'    => 'Attributs filtrables',
                'general'                  => 'Général',
                'logo'                     => 'Logo',
                'logo-size'                => 'Résolution du logo doit être (110px X 110px)',
                'meta-description'         => 'Méta-description',
                'meta-keywords'            => 'Méta-mots-clés',
                'meta-title'               => 'Méta-titre',
                'name'                     => 'Nom',
                'position'                 => 'Position*',
                'products-and-description' => 'Produits et description',
                'products-only'            => 'Produits uniquement',
                'save-btn'                 => 'Enregistrer la catégorie',
                'select-display-mode'      => 'Sélectionner le mode d\'affichage',
                'select-parent-category'   => 'Sélectionner la catégorie parente*',
                'seo-details'              => 'Détails SEO',
                'settings'                 => 'Paramètres',
                'slug'                     => 'Slug',
                'title'                    => 'Modifier la catégorie',
                'visible-in-menu'          => 'Visible dans le menu',
            ],

            'category'             => 'Catégorie',
            'create-success'       => 'Catégorie créée avec succès.',
            'delete-category-root' => 'La catégorie racine ne peut pas être supprimée.',
            'delete-failed'        => 'Erreur lors de la suppression de la catégorie',
            'delete-success'       => 'La catégorie a été supprimée avec succès.',
            'update-success'       => 'Catégorie mise à jour avec succès.',
        ],

        'families'   => [
            'index' => [
                'add'   => 'Créer une famille d\'attributs',
                'title' => 'Familles',

                'datagrid' => [
                    'code'           => 'Code',
                    'delete'         => 'Supprimer',
                    'delete-success' => ':resource sélectionnées ont été supprimées avec succès',
                    'edit'           => 'Modifier',
                    'id'             => 'ID',
                    'method-error'   => 'Erreur ! Méthode incorrecte détectée, veuillez vérifier la configuration de l\'action en masse',
                    'name'           => 'Nom',
                    'no-resource'    => 'La ressource fournie est insuffisante pour l\'action',
                    'partial-action' => 'Certaines actions n\'ont pas été effectuées en raison de contraintes système restreintes sur :resource',
                    'update-success' => ':resource sélectionnées ont été mises à jour avec succès',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Ajouter un groupe',
                'add-group-title'                  => 'Ajouter un nouveau groupe',
                'back-btn'                         => 'Retour',
                'code'                             => 'Code',
                'column'                           => 'Colonne',
                'delete-group-btn'                 => 'Supprimer le groupe',
                'edit-group-info'                  => 'Double-cliquez pour modifier le groupe',
                'enter-code'                       => 'Saisir le code',
                'enter-name'                       => 'Saisir le nom',
                'general'                          => 'Général',
                'group-code-already-exists'        => 'Un code de groupe d\'attributs existe déjà.',
                'group-contains-system-attributes' => 'Ce groupe contient des attributs système. Déplacez d\'abord les attributs système vers un autre groupe et réessayez.',
                'group-name-already-exists'        => 'Un nom de groupe d\'attributs existe déjà.',
                'groups'                           => 'Groupes',
                'groups-info'                      => 'Gérer les groupes de famille d\'attributs',
                'main-column'                      => 'Colonne principale',
                'name'                             => 'Nom',
                'removal-not-possible'             => 'Vous ne pouvez pas supprimer les attributs système de la famille d\'attributs.',
                'right-column'                     => 'Colonne de droite',
                'save-btn'                         => 'Enregistrer la famille d\'attributs',
                'select-group'                     => 'Veuillez sélectionner un groupe d\'attributs.',
                'title'                            => 'Créer une famille d\'attributs',
                'unassigned-attributes'            => 'Attributs non assignés',
                'unassigned-attributes-info'       => 'Faites glisser ces attributs pour les ajouter aux colonnes ou aux groupes.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Ajouter un groupe',
                'add-group-title'                  => 'Ajouter un nouveau groupe',
                'back-btn'                         => 'Retour',
                'code'                             => 'Code',
                'column'                           => 'Colonne',
                'delete-group-btn'                 => 'Supprimer le groupe',
                'edit-group-info'                  => 'Double-cliquez pour modifier le groupe',
                'enter-code'                       => 'Saisir le code',
                'enter-name'                       => 'Saisir le nom',
                'general'                          => 'Général',
                'group-code-already-exists'        => 'Un code de groupe d\'attributs existe déjà.',
                'group-contains-system-attributes' => 'Ce groupe contient des attributs système. Déplacez d\'abord les attributs système vers un autre groupe et réessayez.',
                'group-name-already-exists'        => 'Un nom de groupe d\'attributs existe déjà.',
                'groups'                           => 'Groupes',
                'groups-info'                      => 'Gérer les groupes de famille d\'attributs',
                'main-column'                      => 'Colonne principale',
                'name'                             => 'Nom',
                'removal-not-possible'             => 'Vous ne pouvez pas supprimer les attributs système de la famille d\'attributs.',
                'right-column'                     => 'Colonne de droite',
                'save-btn'                         => 'Enregistrer la famille d\'attributs',
                'select-group'                     => 'Veuillez sélectionner un groupe d\'attributs.',
                'title'                            => 'Modifier la famille d\'attributs',
                'unassigned-attributes'            => 'Attributs non assignés',
                'unassigned-attributes-info'       => 'Faites glisser ces attributs pour les ajouter aux colonnes ou aux groupes.',
            ],

            'attribute-family'        => 'Famille d\'attributs',
            'attribute-product-error' => 'La famille est utilisée dans des produits.',
            'create-success'          => 'Famille créée avec succès.',
            'delete-failed'           => 'Erreur rencontrée lors de la suppression de la famille.',
            'delete-success'          => 'Famille supprimée avec succès.',
            'family'                  => 'Famille',
            'last-delete-error'       => 'Au moins une famille est requise.',
            'update-success'          => 'Famille mise à jour avec succès.',
            'user-define-error'       => 'Impossible de supprimer la famille d\'attributs système',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Clients',
                'login-message' => 'Vous êtes connecté en tant que :customer_name',

                'datagrid' => [
                    'active'         => 'Actif',
                    'address'        => ':address  Adresse(s)',
                    'address-count'  => 'Nombre d\'adresses',
                    'channel'        => 'Chaîne',
                    'delete'         => 'Supprimer',
                    'delete-success' => 'Données sélectionnées supprimées avec succès',
                    'email'          => 'E-mail',
                    'gender'         => 'Genre',
                    'group'          => 'Groupe',
                    'id'             => 'Identifiant du client',
                    'id-value'       => 'ID - :id',
                    'inactive'       => 'Inactif',
                    'method-error'   => 'Erreur ! Méthode incorrecte détectée, veuillez vérifier la configuration de l\'action de masse',
                    'name'           => 'Nom du client',
                    'no-resource'    => 'La ressource fournie est insuffisante pour l\'action',
                    'order'          => ':order Commande(s)',
                    'order-count'    => 'Nombre de commandes',
                    'order-pending'  => 'Le client a une commande en attente',
                    'partial-action' => 'Certaines actions n\'ont pas été effectuées en raison de contraintes système restreintes sur :resource',
                    'phone'          => 'Numéro de contact',
                    'revenue'        => 'Revenu',
                    'status'         => 'Statut',
                    'suspended'      => 'Suspendu',
                    'update-status'  => 'Mettre à jour le statut',
                    'update-success' => 'Clients sélectionnés mis à jour avec succès',
                ],

                'create' => [
                    'contact-number'        => 'Numéro de contact',
                    'create-btn'            => 'Créer un client',
                    'create-success'        => 'Client créé avec succès',
                    'customer-group'        => 'Groupe de clients',
                    'date-of-birth'         => 'Date de naissance',
                    'email'                 => 'E-mail',
                    'female'                => 'Femme',
                    'first-name'            => 'Prénom',
                    'gender'                => 'Genre',
                    'last-name'             => 'Nom de famille',
                    'male'                  => 'Homme',
                    'other'                 => 'Autre',
                    'save-btn'              => 'Enregistrer le client',
                    'select-customer-group' => 'Sélectionner le groupe de clients',
                    'select-gender'         => 'Sélectionner le genre',
                    'title'                 => 'Créer un nouveau client',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'Êtes-vous sûr de vouloir supprimer ce compte?',
                'active'                      => 'Actif',
                'address-delete-confirmation' => 'Êtes-vous sûr de vouloir supprimer cette adresse?',
                'back-btn'                    => 'Retour',
                'create-order'                => 'Créer une commande',
                'customer'                    => 'Client',
                'date-of-birth'               => 'DOB - :dob',
                'default-address'             => 'Adresse par défaut',
                'delete-account'              => 'Supprimer le compte',
                'delete'                      => 'Supprimer',
                'email'                       => 'E-mail - :email',
                'empty-description'           => 'Créer de nouvelles adresses pour le client',
                'empty-title'                 => 'Ajouter une adresse client',
                'gender'                      => 'Genre - :gender',
                'group'                       => 'Groupe - :group_code',
                'inactive'                    => 'Inactif',
                'login-as-customer'           => 'Se connecter en tant que client',
                'note-created-success'        => 'Note créée avec succès',
                'order-create-confirmation'   => 'Êtes-vous sûr de vouloir créer une commande pour ce client?',
                'phone'                       => 'Téléphone - :phone',
                'set-as-default'              => 'Définir comme par défaut',
                'suspended'                   => 'Suspendu',
                'title'                       => 'Vue du client',

                'address' => [
                    'count' => 'Adresses (:count)',

                    'create' => [
                        'city'               => 'Ville',
                        'company-name'       => 'Nom de l\'entreprise',
                        'country'            => 'Pays',
                        'create-btn'         => 'Créer',
                        'create-address-btn' => 'Ajouter une nouvelle adresse',
                        'default-address'    => 'Adresse par défaut',
                        'email'              => 'E-mail',
                        'first-name'         => 'Prénom',
                        'last-name'          => 'Nom de famille',
                        'phone'              => 'Téléphone',
                        'post-code'          => 'Code postal',
                        'save-btn-title'     => 'Enregistrer l\'adresse',
                        'select-country'     => 'Sélectionner un pays',
                        'state'              => 'État',
                        'street-address'     => 'Adresse',
                        'title'              => 'Créer une adresse',
                        'vat-id'             => 'Numéro de TVA',
                    ],

                    'edit' => [
                        'city'            => 'Ville',
                        'company-name'    => 'Nom de l\'entreprise',
                        'country'         => 'Pays',
                        'default-address' => 'Adresse par défaut',
                        'edit-btn'        => 'Éditer',
                        'email'           => 'E-mail',
                        'first-name'      => 'Prénom',
                        'last-name'       => 'Nom de famille',
                        'phone'           => 'Téléphone',
                        'post-code'       => 'Code postal',
                        'save-btn-title'  => 'Enregistrer l\'adresse',
                        'select-country'  => 'Sélectionner un pays',
                        'state'           => 'État',
                        'street-address'  => 'Adresse',
                        'title'           => 'Éditer l\'adresse',
                        'vat-id'          => 'Numéro de TVA',
                    ],

                    'address-delete-success' => 'Adresse supprimée avec succès',
                    'create-success'         => 'Adresse créée avec succès',
                    'set-default-success'    => 'Adresse par défaut mise à jour avec succès',
                    'success-mass-delete'    => 'Suppression en masse d\'adresses réussie',
                    'update-success'         => 'Adresse mise à jour avec succès',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'Aucune critique disponible',
                        'increment-id'   => 'ID des factures',
                        'invoice-amount' => 'Montant des factures',
                        'invoice-date'   => 'Date des factures',
                        'order-id'       => 'ID de la commande',
                        'view'           => 'Voir',
                    ],

                    'orders' => [
                        'canceled'        => 'Annulé',
                        'channel-name'    => 'Nom de la chaîne',
                        'closed'          => 'Fermé',
                        'completed'       => 'Terminé',
                        'customer-name'   => 'Nom du client',
                        'date'            => 'Date',
                        'empty-order'     => 'Aucune commande disponible',
                        'email'           => 'E-mail',
                        'fraud'           => 'Fraude',
                        'grand-total'     => 'Total général',
                        'location'        => 'Emplacement',
                        'order-id'        => 'ID de la commande',
                        'pay-via'         => 'Payer par',
                        'pending'         => 'En attente',
                        'pending-payment' => 'Paiement en attente',
                        'processing'      => 'En cours de traitement',
                        'status'          => 'Statut',
                        'view'            => 'Voir',
                    ],

                    'reviews' => [
                        'approved'      => 'Approuvé',
                        'comment'       => 'Commentaire',
                        'created-at'    => 'Créé le',
                        'disapproved'   => 'Désapprouvé',
                        'empty-reviews' => 'Aucune facture disponible',
                        'id'            => 'ID',
                        'invoice-date'  => 'Date de la facture',
                        'pending'       => 'En attente',
                        'product-id'    => 'ID du produit',
                        'product-name'  => 'Nom du produit',
                        'rating'        => 'Note',
                        'status'        => 'Statut',
                        'title'         => 'Titre',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Numéro de contact',
                    'customer-group'        => 'Groupe de clients',
                    'date-of-birth'         => 'Date de naissance',
                    'edit-btn'              => 'Éditer',
                    'email'                 => 'E-mail',
                    'female'                => 'Femme',
                    'first-name'            => 'Prénom',
                    'gender'                => 'Genre',
                    'last-name'             => 'Nom de famille',
                    'male'                  => 'Homme',
                    'other'                 => 'Autre',
                    'save-btn'              => 'Enregistrer le client',
                    'select-customer-group' => 'Sélectionner le groupe de clients',
                    'select-gender'         => 'Sélectionner le genre',
                    'status'                => 'Statut',
                    'suspended'             => 'Suspendu',
                    'title'                 => 'Éditer le client',
                ],

                'invoices' => [
                    'count'        => 'Factures (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Ajouter une note',
                    'customer-not-notified' => ':date | Client <b>Non notifié</b>',
                    'customer-notified'     => ':date | Client <b>Notifié</b>',
                    'note'                  => 'Note',
                    'note-placeholder'      => 'Écrivez votre note ici',
                    'notify-customer'       => 'Notifier le client',
                    'submit-btn-title'      => 'Soumettre la note',
                ],

                'orders' => [
                    'count'         => 'Commandes (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Revenu total - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'Avis (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Article du panier supprimé avec succès.',
                ],

                'wishlist' => [
                    'delete-success' => 'Article de la liste de souhaits supprimé avec succès.',
                ],

                'compare' => [
                    'delete-success' => 'Article de comparaison supprimé avec succès.',
                ],
            ],

            'delete-failed'  => 'Échec de la suppression du client',
            'delete-success' => 'Suppression du client réussie',
            'order-pending'  => 'Les commandes sont en attente',
            'update-success' => 'Mise à jour du client réussie',
        ],

        'groups' => [
            'customer-associate' => 'Ce groupe a des clients associés et ne peut pas être supprimé.',

            'index' => [
                'title' => 'Groupes',

                'create' => [
                    'create-btn' => 'Créer un groupe',
                    'code'       => 'Code',
                    'success'    => 'Groupe créé avec succès',
                    'name'       => 'Nom',
                    'save-btn'   => 'Enregistrer le groupe',
                    'title'      => 'Créer un nouveau groupe',
                ],

                'edit' => [
                    'delete-failed'  => 'Échec de la suppression du groupe',
                    'delete-success' => 'Groupe supprimé avec succès',
                    'group-default'  => 'Le groupe par défaut ne peut pas être supprimé',
                    'success'        => 'Groupe mis à jour avec succès',
                    'title'          => 'Modifier le groupe',
                ],

                'datagrid' => [
                    'code'   => 'Code',
                    'delete' => 'Supprimer',
                    'edit'   => 'Modifier',
                    'id'     => 'ID',
                    'name'   => 'Nom',
                ],
            ],
        ],

        'gdpr' => [
            'index' => [
                'title' => 'Demande GDPR',

                'datagrid' => [
                    'completed'     => 'Terminé',
                    'created-at'    => 'Créé à',
                    'customer-name' => 'Nom du client',
                    'declined'      => 'Refusé',
                    'delete'        => 'Supprimer',
                    'edit'          => 'Modifier',
                    'id'            => 'ID',
                    'message'       => 'Message',
                    'pending'       => 'En attente',
                    'processing'    => 'En traitement',
                    'revoked'       => 'Révoqué',
                    'status'        => 'Statut',
                    'type'          => 'Type',
                ],

                'modal' => [
                    'completed'     => 'Terminé',
                    'declined'      => 'Refusé',
                    'message'       => 'Message',
                    'pending'       => 'En attente',
                    'processing'    => 'En traitement',
                    'revoked'       => 'Révoqué',
                    'save-btn'      => 'Enregistrer',
                    'status'        => 'Statut',
                    'title'         => 'Modifier la demande de données GDPR',
                    'type'          => 'Type',
                ],

                'update-success'              => 'Demande de données mise à jour avec succès et e-mail envoyé au client.',
                'delete-success'              => 'Demande de données supprimée avec succès.',
                'attribute-reason-error'      => 'Impossible de supprimer.',
                'update-success-unsent-email' => 'Demande de données mise à jour avec succès mais e-mail non envoyé au client.',
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Date',
                'description' => 'Description',
                'id'          => 'ID',
                'name'        => 'Nom',
                'product'     => 'Produit',
                'rating'      => 'Évaluation',
                'status'      => 'Statut',
                'title'       => 'Avis',

                'edit' => [
                    'approved'       => 'Approuvé',
                    'customer'       => 'Client',
                    'date'           => 'Date',
                    'disapproved'    => 'Désapprouvé',
                    'id'             => 'ID',
                    'images'         => 'Images',
                    'pending'        => 'En attente',
                    'product'        => 'Produit',
                    'rating'         => 'Évaluation',
                    'review-comment' => 'Commentaire',
                    'review-title'   => 'Titre',
                    'save-btn'       => 'Enregistrer',
                    'status'         => 'Statut',
                    'title'          => 'Modifier l\'avis',
                    'update-success' => 'Mise à jour réussie',
                ],

                'datagrid' => [
                    'approved'            => 'Approuvé',
                    'comment'             => 'Commentaire',
                    'customer-names'      => 'Nom',
                    'date'                => 'Date',
                    'delete'              => 'Supprimer',
                    'delete-success'      => 'Avis supprimé avec succès',
                    'disapproved'         => 'Désapprouvé',
                    'edit'                => 'Modifier',
                    'id'                  => 'ID',
                    'mass-delete-error'   => 'Une erreur s\'est produite',
                    'mass-delete-success' => 'Avis sélectionnés supprimés avec succès',
                    'mass-update-success' => 'Avis sélectionnés mis à jour avec succès',
                    'pending'             => 'En attente',
                    'product'             => 'Produit',
                    'rating'              => 'Évaluation',
                    'review-id'           => 'ID - :review_id',
                    'status'              => 'Statut',
                    'title'               => 'Titre',
                    'update-status'       => 'Mettre à jour le statut',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Créer un modèle',
                    'title'      => 'Modèles d\'e-mail',

                    'datagrid' => [
                        'active'   => 'Actif',
                        'draft'    => 'Brouillon',
                        'id'       => 'ID',
                        'inactive' => 'Inactif',
                        'name'     => 'Nom',
                        'status'   => 'Statut',
                    ],
                ],

                'create' => [
                    'active'         => 'Actif',
                    'back-btn'       => 'Retour',
                    'content'        => 'Contenu',
                    'create-success' => 'Modèle d\'e-mail créé avec succès.',
                    'draft'          => 'Brouillon',
                    'general'        => 'Général',
                    'inactive'       => 'Inactif',
                    'name'           => 'Nom',
                    'save-btn'       => 'Enregistrer le modèle',
                    'select-status'  => 'Sélectionner le statut',
                    'status'         => 'Statut',
                    'title'          => 'Créer un modèle',
                ],

                'edit' => [
                    'active'         => 'Actif',
                    'back-btn'       => 'Retour',
                    'content'        => 'Contenu*',
                    'draft'          => 'Brouillon',
                    'general'        => 'Général',
                    'inactive'       => 'Inactif',
                    'name'           => 'Nom',
                    'save-btn'       => 'Enregistrer le modèle',
                    'status'         => 'Statut',
                    'title'          => 'Modifier le modèle',
                    'update-success' => 'Mise à jour réussie',
                ],

                'delete-failed'  => ':name Échec de la suppression',
                'delete-success' => 'Modèle supprimé avec succès',
                'email-template' => 'Modèle d\'e-mail',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => 'Créer une campagne',
                    'title'      => 'Campagnes',

                    'datagrid' => [
                        'active'   => 'Actif',
                        'delete'   => 'Supprimer',
                        'edit'     => 'Modifier',
                        'id'       => 'ID',
                        'inactive' => 'Inactif',
                        'name'     => 'Nom',
                        'status'   => 'Statut',
                        'subject'  => 'Sujet',
                    ],
                ],

                'create' => [
                    'active'          => 'Actif',
                    'back-btn'        => 'Retour',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Groupe de clients',
                    'email-template'  => 'Modèle d\'e-mail',
                    'event'           => 'Événement',
                    'general'         => 'Général',
                    'inactive'        => 'Inactif',
                    'name'            => 'Nom',
                    'save-btn'        => 'Enregistrer la campagne',
                    'select-channel'  => 'Sélectionner une chaîne',
                    'select-event'    => 'Sélectionner un événement',
                    'select-group'    => 'Sélectionner un groupe',
                    'select-status'   => 'Sélectionner le statut',
                    'select-template' => 'Sélectionner un modèle',
                    'setting'         => 'Paramètre',
                    'status'          => 'Statut',
                    'subject'         => 'Sujet',
                    'title'           => 'Créer une campagne',
                ],

                'edit' => [
                    'active'          => 'Actif',
                    'audience'        => 'Audience',
                    'back-btn'        => 'Retour',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Groupe de clients',
                    'email-template'  => 'Modèle d\'e-mail',
                    'event'           => 'Événement',
                    'general'         => 'Général',
                    'inactive'        => 'Inactif',
                    'name'            => 'Nom',
                    'save-btn'        => 'Enregistrer la campagne',
                    'select-event'    => 'Sélectionner un événement',
                    'select-status'   => 'Sélectionner le statut',
                    'select-template' => 'Sélectionner un modèle',
                    'status'          => 'Statut',
                    'subject'         => 'Sujet',
                    'title'           => 'Modifier la campagne',
                ],

                'create-success' => 'Campagne créée avec succès.',
                'delete-failed'  => ':name Échec de la suppression',
                'delete-success' => 'Campagne supprimée avec succès',
                'email-campaign' => 'Campagne par e-mail',
                'update-success' => 'Campagne mise à jour avec succès.',
            ],

            'events' => [
                'index' => [
                    'create-btn' => 'Créer un événement',
                    'event'      => 'Événement',
                    'title'      => 'Événements',

                    'datagrid' => [
                        'actions' => 'Actions',
                        'date'    => 'Date',
                        'delete'  => 'Supprimer',
                        'edit'    => 'Modifier',
                        'id'      => 'ID',
                        'name'    => 'Nom',
                    ],

                    'create' => [
                        'date'           => 'Date',
                        'delete-warning' => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                        'description'    => 'Description',
                        'general'        => 'Général',
                        'name'           => 'Nom',
                        'save-btn'       => 'Enregistrer l\'événement',
                        'success'        => 'Événements créés avec succès',
                        'title'          => 'Créer des événements',
                    ],

                    'edit' => [
                        'success' => 'Événements mis à jour avec succès',
                        'title'   => 'Modifier des événements',
                    ],
                ],

                'delete-failed'  => ':name Échec de la suppression',
                'delete-success' => 'Événements supprimés avec succès',
                'edit-error'     => 'Impossible de modifier l\'événement',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Abonnements à la newsletter',

                    'datagrid' => [
                        'actions'    => 'Actions',
                        'delete'     => 'Supprimer',
                        'edit'       => 'Modifier',
                        'email'      => 'E-mail',
                        'false'      => 'Faux',
                        'id'         => 'ID',
                        'subscribed' => 'Abonné',
                        'true'       => 'Vrai',
                    ],

                    'edit' => [
                        'back-btn'      => 'Retour',
                        'email'         => 'E-mail',
                        'false'         => 'Faux',
                        'save-btn'      => 'Enregistrer l\'abonné',
                        'subscribed'    => 'Abonné',
                        'success'       => 'Abonnement à la newsletter mis à jour avec succès',
                        'title'         => 'Modifier l\'abonné à la newsletter',
                        'true'          => 'Vrai',
                        'update-failed' => 'Abonnement à la newsletter non mis à jour',
                    ],
                ],

                'delete-failed'  => 'Échec de la suppression de l\'abonné',
                'delete-success' => 'Abonné supprimé avec succès',
                'delete-warning' => 'Êtes-vous sûr de vouloir effectuer cette action ?',
            ],
        ],

        'promotions' => [
            'index' => [
                'catalog-rule-title' => 'Règles du catalogue',
                'cart-rule-title'    => 'Règles du panier',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Créer une règle du panier',
                    'title'      => 'Règles du panier',

                    'datagrid' => [
                        'active'      => 'Actif',
                        'copy'        => 'Copier',
                        'copy-of'     => ':value',
                        'coupon-code' => 'Code promo',
                        'delete'      => 'Supprimer',
                        'draft'       => 'Brouillon',
                        'edit'        => 'Modifier',
                        'end'         => 'Fin',
                        'id'          => 'ID',
                        'inactive'    => 'Inactif',
                        'name'        => 'Nom',
                        'priority'    => 'Priorité',
                        'start'       => 'Début',
                        'status'      => 'Statut',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Type d\'action',
                    'actions'                                   => 'Actions',
                    'add-condition'                             => 'Ajouter une condition',
                    'additional'                                => 'Supplémentaire',
                    'all-conditions-true'                       => 'Toutes les conditions sont vraies',
                    'any-conditions-true'                       => 'Toutes les conditions sont vraies',
                    'apply-to-shipping'                         => 'Appliquer aux frais d\'expédition',
                    'attribute-family'                          => 'Famille d\'attributs',
                    'attribute-name-children-only'              => ':attribute_name (enfants uniquement)',
                    'attribute-name-parent-only'                => ':attribute_name (parents uniquement)',
                    'auto-generate-coupon'                      => 'Générer automatiquement le coupon',
                    'back-btn'                                  => 'Retour',
                    'buy-x-get-y-free'                          => 'Achetez X, obtenez Y gratuitement',
                    'buy-x-quantity'                            => 'Achetez une quantité de X',
                    'cart-attribute'                            => 'Attribut du panier',
                    'cart-item-attribute'                       => 'Attribut d’article de panier',
                    'categories'                                => 'Catégories',
                    'channels'                                  => 'Canaux',
                    'children-categories'                       => 'Catégories (Enfants uniquement)',
                    'choose-condition-to-add'                   => 'Choisissez la condition à ajouter',
                    'condition-type'                            => 'Type de condition',
                    'conditions'                                => 'Conditions',
                    'contain'                                   => 'Contient',
                    'contains'                                  => 'Contient',
                    'coupon-code'                               => 'Code promo',
                    'coupon-type'                               => 'Type de coupon',
                    'create-success'                            => 'Règle de panier créée avec succès',
                    'customer-groups'                           => 'Groupes de clients',
                    'description'                               => 'Description',
                    'discount-amount'                           => 'Montant de la réduction',
                    'does-not-contain'                          => 'Ne contient pas',
                    'end-of-other-rules'                        => 'Fin des autres règles',
                    'equals-or-greater-than'                    => 'Égal ou supérieur à',
                    'equals-or-less-than'                       => 'Égal ou inférieur à',
                    'fixed-amount'                              => 'Montant fixe',
                    'fixed-amount-whole-cart'                   => 'Montant fixe sur tout le panier',
                    'free-shipping'                             => 'Livraison gratuite',
                    'from'                                      => 'De',
                    'general'                                   => 'Général',
                    'greater-than'                              => 'Supérieur à',
                    'is-equal-to'                               => 'Est égal à',
                    'is-not-equal-to'                           => 'N\'est pas égal à',
                    'less-than'                                 => 'Inférieur à',
                    'marketing-time'                            => 'Temps de marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantité maximale autorisée à être réduite',
                    'name'                                      => 'Nom',
                    'no'                                        => 'Non',
                    'no-coupon'                                 => 'Pas de coupon',
                    'parent-categories'                         => 'Catégories (Parents uniquement)',
                    'payment-method'                            => 'Moyen de paiement',
                    'percentage-product-price'                  => 'Pourcentage du prix du produit',
                    'price-in-cart'                             => 'Prix dans le panier',
                    'priority'                                  => 'Priorité',
                    'product-attribute'                         => 'Attribut de produit',
                    'qty-in-cart'                               => 'Quantité dans le panier',
                    'save-btn'                                  => 'Enregistrer la règle du panier',
                    'settings'                                  => 'Paramètres',
                    'shipping-country'                          => 'Pays de livraison',
                    'shipping-method'                           => 'Méthode d’expédition',
                    'shipping-postcode'                         => 'Code postal de livraison',
                    'shipping-state'                            => 'État de livraison',
                    'specific-coupon'                           => 'Coupon spécifique',
                    'status'                                    => 'Statut',
                    'subtotal'                                  => 'Sous-total',
                    'title'                                     => 'Créer une règle du panier',
                    'to'                                        => 'À',
                    'total-items-qty'                           => 'Quantité totale d’articles',
                    'total-weight'                              => 'Poids total',
                    'uses-per-coupon'                           => 'Utilisations par coupon',
                    'uses-per-customer'                         => 'Utilisations par client',
                    'uses-per-customer-control-info'            => 'Sera utilisé uniquement pour les clients connectés.',
                    'yes'                                       => 'Oui',
                ],

                'edit' => [
                    'action-type'                               => 'Type d’action',
                    'actions'                                   => 'Actions',
                    'add-condition'                             => 'Ajouter une condition',
                    'additional'                                => 'Supplémentaire',
                    'all-conditions-true'                       => 'Toutes les conditions sont vraies',
                    'alphabetical'                              => 'Alphabétique',
                    'alphanumeric'                              => 'Alphanumérique',
                    'any-conditions-true'                       => 'Une ou plusieurs conditions sont vraies',
                    'apply-to-shipping'                         => 'Appliquer aux frais de livraison',
                    'attribute-family'                          => 'Famille d\'attributs',
                    'attribute-name-children-only'              => ':attribute_name (enfants uniquement)',
                    'attribute-name-parent-only'                => ':attribute_name (parents uniquement)',
                    'auto-generate-coupon'                      => 'Générer automatiquement le coupon',
                    'back-btn'                                  => 'Retour',
                    'buy-x-get-y-free'                          => 'Achetez X, obtenez Y gratuitement',
                    'buy-x-quantity'                            => 'Achetez une quantité X',
                    'cart-attribute'                            => 'Attribut du panier',
                    'cart-item-attribute'                       => 'Attribut de l\'article du panier',
                    'categories'                                => 'Catégories',
                    'channels'                                  => 'Canaux',
                    'children-categories'                       => 'Catégories enfants',
                    'choose-condition-to-add'                   => 'Choisissez la condition à ajouter',
                    'code-format'                               => 'Format du code',
                    'code-prefix'                               => 'Préfixe du code',
                    'code-suffix'                               => 'Suffixe du code',
                    'condition-type'                            => 'Type de condition',
                    'conditions'                                => 'Conditions',
                    'contain'                                   => 'Contient',
                    'contains'                                  => 'Contient',
                    'coupon-code'                               => 'Code de coupon',
                    'coupon-length'                             => 'Longueur du coupon',
                    'coupon-qty'                                => 'Quantité de coupons',
                    'coupon-type'                               => 'Type de coupon',
                    'customer-group'                            => 'Groupe de clients',
                    'customer-groups'                           => 'Groupes de clients',
                    'description'                               => 'Description',
                    'discount-amount'                           => 'Montant de la réduction',
                    'does-not-contain'                          => 'Ne contient pas',
                    'end-of-other-rules'                        => 'Fin des autres règles',
                    'equals-or-greater-than'                    => 'Est égal ou supérieur à',
                    'equals-or-less-than'                       => 'Est égal ou inférieur à',
                    'fixed-amount'                              => 'Montant fixe',
                    'fixed-amount-whole-cart'                   => 'Montant fixe pour tout le panier',
                    'free-shipping'                             => 'Livraison gratuite',
                    'from'                                      => 'De',
                    'general'                                   => 'Général',
                    'generate'                                  => 'Générer',
                    'greater-than'                              => 'Supérieur à',
                    'is-equal-to'                               => 'Est égal à',
                    'is-not-equal-to'                           => 'N\'est pas égal à',
                    'less-than'                                 => 'Inférieur à',
                    'marketing-time'                            => 'Période marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Quantité maximale autorisée à être réduite',
                    'name'                                      => 'Nom',
                    'no'                                        => 'Non',
                    'no-coupon'                                 => 'Pas de coupon',
                    'numeric'                                   => 'Numérique',
                    'parent-categories'                         => 'Catégories parentes',
                    'payment-method'                            => 'Méthode de paiement',
                    'percentage-product-price'                  => 'Pourcentage du prix du produit',
                    'price-in-cart'                             => 'Prix dans le panier',
                    'priority'                                  => 'Priorité',
                    'product-attribute'                         => 'Attribut du produit',
                    'qty-in-cart'                               => 'Quantité dans le panier',
                    'save-btn'                                  => 'Enregistrer la règle du panier',
                    'settings'                                  => 'Paramètres',
                    'shipping-country'                          => 'Pays de livraison',
                    'shipping-method'                           => 'Méthode de livraison',
                    'shipping-postcode'                         => 'Code postal de livraison',
                    'shipping-state'                            => 'État de livraison',
                    'specific-coupon'                           => 'Coupon spécifique',
                    'status'                                    => 'Statut',
                    'subtotal'                                  => 'Sous-total',
                    'title'                                     => 'Modifier la règle du panier',
                    'to'                                        => 'À',
                    'total-items-qty'                           => 'Quantité totale d\'articles',
                    'total-weight'                              => 'Poids total',
                    'update-success'                            => 'Règle du panier mise à jour avec succès',
                    'uses-per-coupon'                           => 'Utilisations par coupon',
                    'uses-per-customer'                         => 'Utilisations par client',
                    'uses-per-customer-control-info'            => 'Sera utilisé uniquement pour les clients connectés.',
                    'yes'                                       => 'Oui',
                ],

                'delete-failed'  => 'Échec de la suppression de la règle du panier',
                'delete-success' => 'Règle du panier supprimée avec succès',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'Créer une règle du catalogue',
                    'title'      => 'Règles du catalogue',

                    'datagrid' => [
                        'active'   => 'Actif',
                        'delete'   => 'Supprimer',
                        'edit'     => 'Modifier',
                        'end'      => 'Fin',
                        'id'       => 'ID',
                        'inactive' => 'Inactif',
                        'name'     => 'Nom',
                        'priority' => 'Priorité',
                        'start'    => 'Début',
                        'status'   => 'Statut',
                    ],
                ],

                'create' => [
                    'action-type'              => 'Type d\'action',
                    'actions'                  => 'Actions',
                    'add-condition'            => 'Ajouter une condition',
                    'all-conditions-true'      => 'Toutes les conditions sont vraies',
                    'any-conditions-true'      => 'Une ou plusieurs conditions sont vraies',
                    'attribute-family'         => 'Famille d\'attributs',
                    'back-btn'                 => 'Retour',
                    'categories'               => 'Catégories',
                    'channels'                 => 'Canaux',
                    'choose-condition-to-add'  => 'Choisissez la condition à ajouter',
                    'condition-type'           => 'Type de condition',
                    'conditions'               => 'Conditions',
                    'contain'                  => 'Contient',
                    'contains'                 => 'Contient',
                    'customer-groups'          => 'Groupes de clients',
                    'description'              => 'Description',
                    'discount-amount'          => 'Montant de la réduction',
                    'does-not-contain'         => 'Ne contient pas',
                    'end-other-rules'          => 'Met fin aux autres règles',
                    'equals-or-greater-than'   => 'Est égal ou supérieur à',
                    'equals-or-less-than'      => 'Est égal ou inférieur à',
                    'fixed-amount'             => 'Montant fixe',
                    'from'                     => 'De',
                    'general'                  => 'Général',
                    'greater-than'             => 'Supérieur à',
                    'is-equal-to'              => 'Est égal à',
                    'is-not-equal-to'          => 'N\'est pas égal à',
                    'less-than'                => 'Inférieur à',
                    'marketing-time'           => 'Période marketing',
                    'name'                     => 'Nom',
                    'no'                       => 'Non',
                    'percentage-product-price' => 'Pourcentage du prix du produit',
                    'priority'                 => 'Priorité',
                    'product-attribute'        => 'Attribut du produit',
                    'save-btn'                 => 'Enregistrer la règle du catalogue',
                    'settings'                 => 'Paramètres',
                    'status'                   => 'Statut',
                    'title'                    => 'Créer une règle du catalogue',
                    'to'                       => 'À',
                    'yes'                      => 'Oui',
                ],

                'edit' => [
                    'action-type'              => 'Type d\'action',
                    'actions'                  => 'Actions',
                    'add-condition'            => 'Ajouter une condition',
                    'all-conditions-true'      => 'Toutes les conditions sont vraies',
                    'any-conditions-true'      => 'Une ou plusieurs conditions sont vraies',
                    'back-btn'                 => 'Retour',
                    'categories'               => 'Catégories',
                    'channels'                 => 'Canaux',
                    'choose-condition-to-add'  => 'Choisissez la condition à ajouter',
                    'condition-type'           => 'Type de condition',
                    'conditions'               => 'Conditions',
                    'contain'                  => 'Contient',
                    'contains'                 => 'Contient',
                    'customer-groups'          => 'Groupes de clients',
                    'description'              => 'Description',
                    'discount-amount'          => 'Montant de la réduction',
                    'does-not-contain'         => 'Ne contient pas',
                    'end-other-rules'          => 'Met fin aux autres règles',
                    'equals-or-greater-than'   => 'Est égal ou supérieur à',
                    'equals-or-less-than'      => 'Est égal ou inférieur à',
                    'fixed-amount'             => 'Montant fixe',
                    'from'                     => 'De',
                    'general'                  => 'Général',
                    'greater-than'             => 'Supérieur à',
                    'is-equal-to'              => 'Est égal à',
                    'is-not-equal-to'          => 'N\'est pas égal à',
                    'less-than'                => 'Inférieur à',
                    'marketing-time'           => 'Période marketing',
                    'name'                     => 'Nom',
                    'no'                       => 'Non',
                    'percentage-product-price' => 'Pourcentage du prix du produit',
                    'priority'                 => 'Priorité',
                    'product-attribute'        => 'Attribut du produit',
                    'save-btn'                 => 'Enregistrer la règle du catalogue',
                    'settings'                 => 'Paramètres',
                    'status'                   => 'Statut',
                    'title'                    => 'Modifier la règle du catalogue',
                    'to'                       => 'À',
                    'yes'                      => 'Oui',
                ],

                'create-success' => 'Règle du catalogue créée avec succès',
                'delete-success' => 'Règle du catalogue supprimée avec succès',
                'update-success' => 'Règle du catalogue mise à jour avec succès',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'La règle du panier ne peut pas être supprimée',
                'delete-success'              => 'Coupon de règle du panier supprimé avec succès',
                'mass-delete-success'         => 'Éléments sélectionnés supprimés avec succès',
                'success'                     => ':name créé avec succès',

                'datagrid' => [
                    'coupon-code'     => 'Code coupon',
                    'created-date'    => 'Date de création',
                    'delete'          => 'Supprimer',
                    'expiration-date' => 'Date d\'expiration',
                    'id'              => 'ID',
                    'times-used'      => 'Utilisations',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Créer un nouveau terme de recherche',
                    'title'      => 'Termes de recherche',

                    'datagrid' => [
                        'actions'             => 'Actions',
                        'channel'             => 'Chaîne',
                        'delete'              => 'Supprimer',
                        'edit'                => 'Modifier',
                        'id'                  => 'ID',
                        'locale'              => 'Langue',
                        'mass-delete-success' => 'Termes de recherche sélectionnés supprimés avec succès',
                        'redirect-url'        => 'URL de redirection',
                        'results'             => 'Résultats',
                        'search-query'        => 'Rechercher',
                        'uses'                => 'Utilisations',
                    ],

                    'create' => [
                        'channel'        => 'Chaîne',
                        'delete-warning' => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                        'locale'         => 'Langue',
                        'redirect-url'   => 'URL de redirection',
                        'results'        => 'Résultats',
                        'save-btn'       => 'Enregistrer le terme de recherche',
                        'search-query'   => 'Rechercher',
                        'success'        => 'Terme de recherche nouvellement créé avec succès',
                        'title'          => 'Créer un nouveau terme de recherche',
                        'uses'           => 'Utilisations',
                    ],

                    'edit' => [
                        'delete-success' => 'Terme de recherche supprimé avec succès',
                        'success'        => 'Terme de recherche mis à jour avec succès',
                        'title'          => 'Modifier le terme de recherche',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Créer un synonyme de recherche',
                    'title'      => 'Synonymes de recherche',

                    'datagrid' => [
                        'actions'             => 'Actions',
                        'delete'              => 'Supprimer',
                        'edit'                => 'Modifier',
                        'id'                  => 'ID',
                        'mass-delete-success' => 'Les synonymes de recherche sélectionnés ont été supprimés avec succès',
                        'name'                => 'Nom',
                        'terms'               => 'Termes',
                    ],

                    'create' => [
                        'delete-warning' => 'Êtes-vous sûr de vouloir effectuer cette action?',
                        'name'           => 'Nom',
                        'save-btn'       => 'Enregistrer le synonyme de recherche',
                        'success'        => 'Synonyme de recherche créé avec succès',
                        'terms'          => 'Termes',
                        'terms-info'     => 'Saisissez les synonymes sous forme de liste séparée par des virgules, par exemple "chaussures,chaussure." Cela élargit la recherche pour inclure tous les termes.',
                        'title'          => 'Créer un synonyme de recherche',
                    ],

                    'edit' => [
                        'delete-success' => 'Synonyme de recherche supprimé avec succès',
                        'success'        => 'Synonyme de recherche mis à jour avec succès',
                        'title'          => 'Modifier le synonyme de recherche',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Créer une carte du site',
                    'sitemap'    => 'Plan du site',
                    'title'      => 'Sitemaps',

                    'datagrid' => [
                        'actions'         => 'Actions',
                        'delete'          => 'Supprimer',
                        'edit'            => 'Modifier',
                        'file-name'       => 'Nom de fichier',
                        'id'              => 'ID',
                        'link-for-google' => 'Lien pour Google',
                        'path'            => 'Chemin',
                    ],

                    'create' => [
                        'delete-warning' => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                        'file-name'      => 'Nom de fichier',
                        'file-name-info' => 'Exemple : sitemap.xml',
                        'path'           => 'Chemin',
                        'path-info'      => 'Exemple : "/sitemap/" ou "/" pour le chemin de base',
                        'save-btn'       => 'Enregistrer la carte du site',
                        'success'        => 'Plan du site créé avec succès',
                        'title'          => 'Créer une carte du site',
                    ],

                    'edit' => [
                        'delete-success' => 'Plan du site supprimé avec succès',
                        'success'        => 'Plan du site mis à jour avec succès',
                        'title'          => 'Modifier la carte du site',
                    ],
                ],

                'edit' => [
                    'back-btn'       => 'Retour',
                    'file-name'      => 'Nom de fichier',
                    'file-name-info' => 'Exemple : sitemap.xml',
                    'general'        => 'Général',
                    'path'           => 'Chemin',
                    'path-info'      => 'Exemple : "/sitemap/" ou "/" pour le chemin de base',
                    'save-btn'       => 'Enregistrer la carte du site',
                ],

                'delete-failed' => ':name Suppression Échouée',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'Créer une réécriture d\'URL',
                    'title'      => 'Réécritures d\'URL',

                    'datagrid' => [
                        'actions'             => 'Actions',
                        'category'            => 'Catégorie',
                        'cms-page'            => 'Page CMS',
                        'delete'              => 'Supprimer',
                        'edit'                => 'Modifier',
                        'for'                 => 'Pour',
                        'id'                  => 'ID',
                        'locale'              => 'Localisation',
                        'mass-delete-success' => 'Les réécritures d\'URL sélectionnées ont été supprimées avec succès.',
                        'permanent-redirect'  => 'Permanent (301)',
                        'product'             => 'Produit',
                        'redirect-type'       => 'Type de redirection',
                        'request-path'        => 'Chemin de requête',
                        'target-path'         => 'Chemin de destination',
                        'temporary-redirect'  => 'Temporaire (302)',
                    ],

                    'create' => [
                        'category'           => 'Catégorie',
                        'cms-page'           => 'Page CMS',
                        'delete-warning'     => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                        'for'                => 'Pour',
                        'locale'             => 'Localisation',
                        'permanent-redirect' => 'Permanent (301)',
                        'product'            => 'Produit',
                        'redirect-type'      => 'Type de redirection',
                        'request-path'       => 'Chemin de requête',
                        'save-btn'           => 'Sauvegarder la réécriture d\'URL',
                        'success'            => 'La réécriture d\'URL a été créée avec succès.',
                        'target-path'        => 'Chemin de destination',
                        'temporary-redirect' => 'Temporaire (302)',
                        'title'              => 'Créer une réécriture d\'URL',
                    ],

                    'edit' => [
                        'delete-success' => 'La réécriture d\'URL a été supprimée avec succès.',
                        'success'        => 'La réécriture d\'URL a été mise à jour avec succès.',
                        'title'          => 'Modifier la réécriture d\'URL',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'Le :name est déjà pris.',
            'create-btn'    => 'Créer une page',
            'channel'       => 'Canal',
            'language'      => 'Langue',
            'title'         => 'Pages',

            'datagrid' => [
                'channel'             => 'Chaîne',
                'delete'              => 'Supprimer',
                'edit'                => 'Modifier',
                'id'                  => 'ID',
                'mass-delete-success' => 'Données sélectionnées supprimées avec succès',
                'page-title'          => 'Titre de la page',
                'url-key'             => 'Clé URL',
                'view'                => 'Voir',
            ],
        ],

        'create' => [
            'channels'         => 'Canaux',
            'content'          => 'Contenu',
            'description'      => 'Description',
            'general'          => 'Général',
            'meta-description' => 'Méta-description',
            'meta-keywords'    => 'Méta-mots-clés',
            'meta-title'       => 'Méta-titre',
            'page-title'       => 'Titre de la page',
            'save-btn'         => 'Enregistrer la page',
            'seo'              => 'SEO',
            'title'            => 'Créer une page',
            'url-key'          => 'Clé URL',
        ],

        'edit' => [
            'back-btn'         => 'Retour',
            'channels'         => 'Canaux',
            'content'          => 'Contenu',
            'description'      => 'Description',
            'general'          => 'Général',
            'meta-description' => 'Méta-description',
            'meta-keywords'    => 'Méta-mots-clés',
            'meta-title'       => 'Méta-titre',
            'page-title'       => 'Titre de la page',
            'preview-btn'      => 'Aperçu de la page',
            'save-btn'         => 'Enregistrer la page',
            'seo'              => 'SEO',
            'title'            => 'Modifier la page',
            'url-key'          => 'Clé URL',
        ],

        'create-success' => 'CMS créé avec succès.',
        'delete-success' => 'CMS supprimé avec succès.',
        'no-resource'    => 'La ressource n’existe pas.',
        'update-success' => 'CMS mis à jour avec succès.',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'Créer une locale',
                'locale'     => 'Locale',
                'logo-size'  => 'La résolution de l\'image doit être de 24px x 16px',
                'title'      => 'Paramètres régionaux',

                'datagrid' => [
                    'actions'   => 'Actions',
                    'code'      => 'Code',
                    'delete'    => 'Supprimer',
                    'direction' => 'Direction',
                    'edit'      => 'Modifier',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Nom',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Code',
                    'direction'        => 'Direction',
                    'locale-logo'      => 'Logo de la locale',
                    'name'             => 'Nom',
                    'save-btn'         => 'Enregistrer la locale',
                    'select-direction' => 'Sélectionner la direction',
                    'title'            => 'Créer une locale',
                ],

                'edit' => [
                    'title' => 'Modifier les paramètres régionaux',
                ],

                'create-success'    => 'Locale créée avec succès.',
                'delete-failed'     => 'Échec de la suppression de la locale',
                'delete-success'    => 'Locale supprimée avec succès.',
                'delete-warning'    => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                'last-delete-error' => 'Au moins une locale est requise.',
                'update-success'    => 'Locale mise à jour avec succès.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Créer une devise',
                'currency'   => 'Devise',
                'title'      => 'Devises',

                'datagrid' => [
                    'actions'        => 'Actions',
                    'code'           => 'Code',
                    'delete'         => 'Supprimer',
                    'edit'           => 'Modifier',
                    'id'             => 'ID',
                    'method-error'   => 'Erreur ! Méthode incorrecte détectée, veuillez vérifier la configuration des actions en masse',
                    'name'           => 'Nom',
                    'no-resource'    => 'La ressource fournie est insuffisante pour l’action',
                    'partial-action' => 'Certaines actions n\'ont pas été effectuées en raison de contraintes système restreintes sur :resource',
                    'update-success' => 'Les :resource sélectionnées ont été mises à jour avec succès',
                ],

                'create' => [
                    'code'                   => 'Code',
                    'create-btn'             => 'Créer une devise',
                    'currency-position'      => 'Position de la devise',
                    'decimal'                => 'Décimal',
                    'decimal-separator'      => 'Séparateur décimal',
                    'decimal-separator-note' => 'Le champ :attribute ne peut accepter que les opérateurs virgule (,) et point (.)',
                    'delete-warning'         => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                    'general'                => 'Général',
                    'group-separator'        => 'Séparateur de Groupe',
                    'group-separator-note'   => 'Le champ :attribute ne peut contenir que les caractères virgule (,), point (.), apostrophe (\') et espace ( ).',
                    'name'                   => 'Nom',
                    'save-btn'               => 'Enregistrer la devise',
                    'symbol'                 => 'Symbole',
                    'title'                  => 'Créer une nouvelle devise',
                ],

                'edit' => [
                    'title' => 'Modifier la devise',
                ],

                'create-success'    => 'Devise créée avec succès.',
                'delete-failed'     => 'Échec de la suppression de la devise',
                'delete-success'    => 'Devise supprimée avec succès.',
                'last-delete-error' => 'Au moins une devise est requise.',
                'update-success'    => 'Devise mise à jour avec succès.',
            ],
        ],

        'data-transfer'     => [
            'imports' => [
                'create' => [
                    'action'              => 'Action',
                    'allowed-errors'      => 'Erreurs Autorisées',
                    'back-btn'            => 'Retour',
                    'create-update'       => 'Créer/Mettre à Jour',
                    'delete'              => 'Supprimer',
                    'download-sample'     => 'Télécharger un Exemple',
                    'field-separator'     => 'Séparateur de Champ',
                    'file'                => 'Fichier',
                    'file-info'           => 'Utiliser le chemin relatif à /project-root/storage/app/import, par exemple, product-images, import-images.',
                    'file-info-example'   => 'Par exemple, en cas d\'images de produits, les fichiers doivent être placés dans /project-root/storage/app/import/product-images.',
                    'general'             => 'Général',
                    'images-directory'    => 'Chemin du Répertoire d\'Images',
                    'process-in-queue'    => 'Traitement dans la File d\'Attente',
                    'results'             => 'Résultats',
                    'save-btn'            => 'Enregistrer l\'Importation',
                    'settings'            => 'Paramètres',
                    'skip-errors'         => 'Ignorer les Erreurs',
                    'stop-on-errors'      => 'Arrêter en Cas d\'Erreurs',
                    'title'               => 'Créer une Importation',
                    'type'                => 'Type',
                    'validation-strategy' => 'Stratégie de Validation',
                ],

                'edit' => [
                    'action'              => 'Action',
                    'allowed-errors'      => 'Erreurs Autorisées',
                    'back-btn'            => 'Retour',
                    'create-update'       => 'Créer/Mettre à Jour',
                    'current-file'        => 'Fichier téléchargé actuel',
                    'delete'              => 'Supprimer',
                    'download-sample'     => 'Télécharger un Exemple',
                    'field-separator'     => 'Séparateur de Champ',
                    'file'                => 'Fichier',
                    'file-info'           => 'Utiliser le chemin relatif à /project-root/storage/app/import, par exemple, product-images, import-images.',
                    'file-info-example'   => 'Par exemple, en cas d\'images de produits, les fichiers doivent être placés dans /project-root/storage/app/import/product-images.',
                    'general'             => 'Général',
                    'images-directory'    => 'Chemin du Répertoire d\'Images',
                    'process-in-queue'    => 'Traitement dans la File d\'Attente',
                    'results'             => 'Résultats',
                    'save-btn'            => 'Enregistrer l\'Importation',
                    'settings'            => 'Paramètres',
                    'skip-errors'         => 'Ignorer les Erreurs',
                    'stop-on-errors'      => 'Arrêter en Cas d\'Erreurs',
                    'title'               => 'Éditer une Importation',
                    'type'                => 'Type',
                    'validation-strategy' => 'Stratégie de Validation',
                ],

                'index' => [
                    'button-title' => 'Créer une Importation',
                    'title'        => 'Importations',

                    'datagrid' => [
                        'actions'       => 'Actions',
                        'completed-at'  => 'Terminé à',
                        'created'       => 'Créé',
                        'delete'        => 'Supprimer',
                        'deleted'       => 'Supprimé',
                        'edit'          => 'Éditer',
                        'error-file'    => 'Fichier d\'Erreur',
                        'id'            => 'ID',
                        'started-at'    => 'Commencé à',
                        'state'         => 'État',
                        'summary'       => 'Résumé',
                        'updated'       => 'Mis à Jour',
                        'uploaded-file' => 'Fichier Téléchargé',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Retour',
                    'completed-batches'       => 'Total de Lots Terminés :',
                    'download-error-report'   => 'Télécharger le Rapport Complet',
                    'edit-btn'                => 'Éditer',
                    'imported-info'           => 'Félicitations ! Votre importation a réussi.',
                    'importing-info'          => 'Importation en Cours',
                    'indexing-info'           => 'Indexation des Ressources (Prix, Inventaire et Recherche Élastique) en Cours',
                    'linking-info'            => 'Liage des Ressources en Cours',
                    'progress'                => 'Avancement :',
                    'title'                   => 'Importation',
                    'total-batches'           => 'Total de Lots :',
                    'total-created'           => 'Total d\'Enregistrements Créés :',
                    'total-deleted'           => 'Total d\'Enregistrements Supprimés :',
                    'total-errors'            => 'Total d\'Erreurs :',
                    'total-invalid-rows'      => 'Total de Lignes Non Validées :',
                    'total-rows-processed'    => 'Total de Lignes Traitées :',
                    'total-updated'           => 'Total d\'Enregistrements Mis à Jour :',
                    'validate-info'           => 'Cliquez sur Valider les Données pour vérifier votre importation.',
                    'validate'                => 'Valider',
                    'validating-info'         => 'La lecture et la validation des données ont commencé',
                    'validation-failed-info'  => 'Votre importation est invalide. Veuillez corriger les erreurs suivantes et réessayer.',
                    'validation-success-info' => 'Votre importation est valide. Cliquez sur Importer pour démarrer le processus d\'importation.',
                ],

                'create-success'    => 'Importation créée avec succès.',
                'delete-failed'     => 'Échec inattendu de la suppression de l\'importation.',
                'delete-success'    => 'Importation supprimée avec succès.',
                'not-valid'         => 'L\'importation n\'est pas valide',
                'nothing-to-import' => 'Il n\'y a aucune ressource à importer.',
                'setup-queue-error' => 'Veuillez changer votre pilote de file d\'attente en "database" ou "redis" pour démarrer le processus d\'importation.',
                'update-success'    => 'Importation mise à jour avec succès.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Créer un taux de change',
                'exchange-rate' => 'Taux de change',
                'title'         => 'Taux de change',
                'update-rates'  => 'Mettre à jour les taux de change',

                'create' => [
                    'delete-warning'         => 'Êtes-vous sûr de vouloir effectuer cette action ?',
                    'rate'                   => 'Taux',
                    'save-btn'               => 'Enregistrer le taux de change',
                    'select-target-currency' => 'Sélectionnez la devise cible',
                    'source-currency'        => 'Devise source',
                    'target-currency'        => 'Devise cible',
                    'title'                  => 'Créer un taux de change',
                ],

                'edit' => [
                    'title' => 'Modifier les taux de change',
                ],

                'datagrid' => [
                    'actions'       => 'Actions',
                    'currency-name' => 'Nom de la devise',
                    'delete'        => 'Supprimer',
                    'edit'          => 'Modifier',
                    'exchange-rate' => 'Taux de change',
                    'id'            => 'ID',
                ],

                'create-success' => 'Taux de change créé avec succès',
                'delete-error'   => 'Erreur lors de la suppression du taux de change',
                'delete-success' => 'Taux de change supprimé avec succès',
                'update-success' => 'Taux de change mis à jour avec succès',
            ],
        ],

        'inventory-sources' => [
            'index' => [
                'create-btn' => 'Créer une source d\'inventaire',
                'title'      => 'Sources d’inventaire',

                'datagrid' => [
                    'active'   => 'Actif',
                    'code'     => 'Code',
                    'delete'   => 'Supprimer',
                    'edit'     => 'Modifier',
                    'id'       => 'ID',
                    'inactive' => 'Inactif',
                    'name'     => 'Nom',
                    'priority' => 'Priorité',
                    'status'   => 'Statut',
                ],
            ],

            'create' => [
                'add-title'      => 'Ajouter une source d’inventaire',
                'address'        => 'Adresse de la source',
                'back-btn'       => 'Retour',
                'city'           => 'Ville',
                'code'           => 'Code',
                'contact-email'  => 'E-mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informations de contact',
                'contact-name'   => 'Nom',
                'contact-number' => 'Numéro de contact',
                'country'        => 'Pays',
                'description'    => 'Description',
                'general'        => 'Général',
                'latitude'       => 'Latitude',
                'longitude'      => 'Longitude',
                'name'           => 'Nom',
                'postcode'       => 'Code postal',
                'priority'       => 'Priorité',
                'save-btn'       => 'Enregistrer les sources d’inventaire',
                'select-country' => 'Sélectionner un pays',
                'select-state'   => 'Sélectionner un État',
                'settings'       => 'Paramètres',
                'state'          => 'État',
                'status'         => 'Statut',
                'street'         => 'Rue',
                'title'          => 'Sources d’inventaire',
            ],

            'edit' => [
                'back-btn'       => 'Retour',
                'city'           => 'Ville',
                'code'           => 'Code',
                'contact-email'  => 'E-mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informations de contact',
                'contact-name'   => 'Nom',
                'contact-number' => 'Numéro de contact',
                'country'        => 'Pays',
                'description'    => 'Description',
                'general'        => 'Général',
                'latitude'       => 'Latitude',
                'longitude'      => 'Longitude',
                'name'           => 'Nom',
                'postcode'       => 'Code postal',
                'priority'       => 'Priorité',
                'save-btn'       => 'Enregistrer les sources d’inventaire',
                'select-country' => 'Sélectionner un pays',
                'select-state'   => 'Sélectionner un État',
                'settings'       => 'Paramètres',
                'source-address' => 'Adresse de la source',
                'state'          => 'État',
                'status'         => 'Statut',
                'street'         => 'Rue',
                'title'          => 'Modifier les sources d’inventaire',
            ],

            'create-success'    => 'Source d’inventaire créée avec succès',
            'delete-failed'     => 'Échec de la suppression des sources d’inventaire',
            'delete-success'    => 'Sources d’inventaire supprimées avec succès',
            'last-delete-error' => 'Impossible de supprimer la dernière source d’inventaire',
            'update-success'    => 'Sources d’inventaire mises à jour avec succès',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => 'Êtes-vous sûr de vouloir supprimer ?',
                    'tax-category'   => 'Catégorie de taxe',
                    'title'          => 'Catégories de taxes',

                    'datagrid' => [
                        'actions' => 'Actions',
                        'code'    => 'Code',
                        'delete'  => 'Supprimer',
                        'edit'    => 'Modifier',
                        'id'      => 'ID',
                        'name'    => 'Nom',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Ajouter des taux de taxe',
                        'code'          => 'Code',
                        'description'   => 'Description',
                        'empty-text'    => 'Les taux de taxe ne sont pas disponibles, veuillez créer de nouveaux taux de taxe.',
                        'general'       => 'Catégorie de taxe',
                        'name'          => 'Nom',
                        'save-btn'      => 'Enregistrer la catégorie de taxe',
                        'select'        => 'Sélectionner',
                        'tax-rates'     => 'Taux de taxe',
                        'title'         => 'Créer une catégorie de taxe',
                    ],

                    'edit' => [
                        'title'   => 'Modifier les catégories de taxe',
                    ],

                    'can-not-delete' => 'Les catégories assignées aux taux de taxe ne peuvent pas être supprimées.',
                    'create-success' => 'Nouvelle catégorie de taxe créée',
                    'delete-failed'  => 'Échec de la suppression de la catégorie de taxe',
                    'delete-success' => 'Catégorie de taxe supprimée avec succès',
                    'update-success' => 'Catégorie de taxe mise à jour avec succès',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => 'Créer un taux de taxe',
                    'tax-rate'     => 'Taux de taxe',
                    'title'        => 'Taux de taxe',

                    'datagrid' => [
                        'country'    => 'Pays',
                        'delete'     => 'Supprimer',
                        'edit'       => 'Modifier',
                        'id'         => 'ID',
                        'identifier' => 'Identifiant',
                        'state'      => 'État',
                        'tax-rate'   => 'Taux de taxe',
                        'zip-code'   => 'Code postal',
                        'zip-from'   => 'Code postal de',
                        'zip-to'     => 'Code postal à',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Retour',
                    'country'        => 'Pays',
                    'general'        => 'Général',
                    'identifier'     => 'Identifiant',
                    'is-zip'         => 'Activer la plage de codes postaux',
                    'save-btn'       => 'Enregistrer le taux de taxe',
                    'select-country' => 'Sélectionner un pays',
                    'select-state'   => 'Sélectionner un État',
                    'settings'       => 'Paramètres',
                    'state'          => 'État',
                    'tax-rate'       => 'Taux',
                    'title'          => 'Créer un taux de taxe',
                    'zip-code'       => 'Code postal',
                    'zip-from'       => 'Code postal de',
                    'zip-to'         => 'Code postal à',
                ],

                'edit' => [
                    'back-btn'       => 'Retour',
                    'country'        => 'Pays',
                    'identifier'     => 'Identifiant',
                    'save-btn'       => 'Enregistrer le taux de taxe',
                    'select-country' => 'Sélectionner un pays',
                    'select-state'   => 'Sélectionner un État',
                    'settings'       => 'Paramètres',
                    'state'          => 'État',
                    'tax-rate'       => 'Taux',
                    'title'          => 'Modifier le taux de taxe',
                    'zip-code'       => 'Code postal',
                    'zip-from'       => 'Code postal de',
                    'zip-to'         => 'Code postal à',
                ],

                'create-success' => 'Taux de taxe créé avec succès.',
                'delete-failed'  => 'Échec de la suppression du taux de taxe',
                'delete-success' => 'Taux de taxe supprimé avec succès',
                'update-success' => 'Taux de taxe mis à jour avec succès',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Créer une chaîne',
                'delete-failed'     => 'Chaîne Échec de la suppression',
                'delete-success'    => 'Chaîne supprimée avec succès.',
                'last-delete-error' => 'La dernière chaîne n\'a pas pu être supprimée.',
                'title'             => 'Chaînes',

                'datagrid' => [
                    'code'      => 'Code',
                    'delete'    => 'Supprimer',
                    'edit'      => 'Éditer',
                    'host-name' => 'Nom de l\'hôte',
                    'id'        => 'ID',
                    'name'      => 'Nom',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'Adresses IP autorisées',
                'cancel'                  => 'Retour',
                'code'                    => 'Code',
                'create-success'          => 'Chaîne créée avec succès.',
                'currencies'              => 'Devises',
                'currencies-and-locales'  => 'Devises et paramètres régionaux',
                'default-currency'        => 'Devise par défaut',
                'default-locale'          => 'Paramètre régional par défaut',
                'description'             => 'Description',
                'design'                  => 'Design',
                'favicon'                 => 'Favicon',
                'favicon-size'            => 'La résolution de l\'image doit être de 16px X 16px',
                'general'                 => 'Général',
                'hostname'                => 'Nom d\'hôte',
                'hostname-placeholder'    => 'https://www.example.com (Ne pas ajouter de barre oblique à la fin.)',
                'inventory-sources'       => 'Sources d\'inventaire',
                'last-delete-error'       => 'Au moins une chaîne est requise.',
                'locales'                 => 'Paramètres régionaux',
                'logo'                    => 'Logo',
                'logo-size'               => 'La résolution de l\'image doit être de 192px X 50px',
                'maintenance-mode-text'   => 'Message',
                'name'                    => 'Nom',
                'root-category'           => 'Catégorie racine',
                'save-btn'                => 'Enregistrer la chaîne',
                'select-default-currency' => 'Sélectionner la devise par défaut',
                'select-default-locale'   => 'Sélectionner la langue par défaut',
                'select-root-category'    => 'Sélectionnez la catégorie racine',
                'select-theme'            => 'Sélectionner le thème',
                'seo'                     => 'SEO de la page d\'accueil',
                'seo-description'         => 'Description méta',
                'seo-keywords'            => 'Mots-clés méta',
                'seo-title'               => 'Titre méta',
                'settings'                => 'Paramètres',
                'status'                  => 'Statut',
                'theme'                   => 'Thème',
                'title'                   => 'Créer une chaîne',
            ],

            'edit' => [
                'allowed-ips'            => 'Adresses IP autorisées',
                'back-btn'               => 'Retour',
                'code'                   => 'Code',
                'currencies'             => 'Devises',
                'currencies-and-locales' => 'Devises et paramètres régionaux',
                'default-currency'       => 'Devise par défaut',
                'default-locale'         => 'Paramètre régional par défaut',
                'description'            => 'Description',
                'design'                 => 'Design',
                'favicon'                => 'Favicon',
                'favicon-size'           => 'La résolution de l\'image doit être de 16px X 16px',
                'general'                => 'Général',
                'hostname'               => 'Nom d\'hôte',
                'hostname-placeholder'   => 'https://www.example.com (Ne pas ajouter de barre oblique à la fin.)',
                'inventory-sources'      => 'Sources d\'inventaire',
                'last-delete-error'      => 'Au moins une chaîne est requise.',
                'locales'                => 'Paramètres régionaux',
                'logo'                   => 'Logo',
                'logo-size'              => 'La résolution de l\'image doit être de 192px X 50px',
                'maintenance-mode'       => 'Mode maintenance',
                'maintenance-mode-text'  => 'Message',
                'name'                   => 'Nom',
                'root-category'          => 'Catégorie racine',
                'save-btn'               => 'Enregistrer la chaîne',
                'seo'                    => 'SEO de la page d\'accueil',
                'seo-description'        => 'Description méta',
                'seo-keywords'           => 'Mots-clés méta',
                'seo-title'              => 'Titre méta',
                'status'                 => 'Statut',
                'theme'                  => 'Thème',
                'title'                  => 'Éditer la chaîne',
                'update-success'         => 'Mise à jour de la chaîne réussie',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Admin',
                'title' => 'Utilisateurs',
                'user'  => 'Utilisateur',

                'create' => [
                    'confirm-password'  => 'Confirmer le mot de passe',
                    'email'             => 'Email',
                    'name'              => 'Nom',
                    'password'          => 'Mot de passe',
                    'role'              => 'Rôle',
                    'save-btn'          => 'Enregistrer l\'utilisateur',
                    'status'            => 'Statut',
                    'title'             => 'Créer un utilisateur',
                    'upload-image-info' => 'Téléchargez une image de profil (110px X 110px) au format PNG ou JPG',
                ],

                'datagrid' => [
                    'actions'  => 'Actions',
                    'active'   => 'Actif',
                    'delete'   => 'Supprimer',
                    'edit'     => 'Éditer',
                    'email'    => 'Email',
                    'id'       => 'ID',
                    'inactive' => 'Inactif',
                    'name'     => 'Nom',
                    'role'     => 'Rôle',
                    'status'   => 'Statut',
                ],

                'edit' => [
                    'title'    => 'Éditer un utilisateur',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Retour',
                'confirm-password' => 'Confirmer le mot de passe',
                'email'            => 'Email',
                'general'          => 'Général',
                'name'             => 'Nom',
                'password'         => 'Mot de passe',
                'role'             => 'Rôle',
                'save-btn'         => 'Enregistrer l\'utilisateur',
                'status'           => 'Statut',
                'title'            => 'Éditer l\'utilisateur',
            ],

            'activate-warning'   => 'Votre compte n\'est pas encore activé, veuillez contacter l\'administrateur.',
            'cannot-change'      => 'L\'utilisateur ne peut pas être modifié.',
            'create-success'     => 'Utilisateur créé avec succès.',
            'delete-failed'      => 'Échec de la suppression de l\'utilisateur.',
            'delete-self-error'  => 'Vous ne pouvez pas supprimer votre propre compte.',
            'delete-success'     => 'Utilisateur supprimé avec succès.',
            'delete-warning'     => 'Êtes-vous sûr de vouloir effectuer cette action ?',
            'incorrect-password' => 'Mot de passe incorrect',
            'last-delete-error'  => 'Échec de la suppression du dernier utilisateur.',
            'login-error'        => 'Veuillez vérifier vos identifiants et réessayer.',
            'update-success'     => 'Utilisateur mis à jour avec succès.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Créer un rôle',
                'title'      => 'Rôles',

                'datagrid' => [
                    'custom'          => 'Personnalisé',
                    'all'             => 'Tous',
                    'permission-type' => 'Type d\'autorisation',
                    'name'            => 'Nom',
                    'id'              => 'ID',
                    'edit'            => 'Éditer',
                    'delete'          => 'Supprimer',
                ],
            ],

            'create' => [
                'access-control' => 'Contrôle d\'accès',
                'all'            => 'Tous',
                'back-btn'       => 'Retour',
                'custom'         => 'Personnalisé',
                'description'    => 'Description',
                'general'        => 'Général',
                'name'           => 'Nom',
                'permissions'    => 'Autorisations',
                'save-btn'       => 'Enregistrer le rôle',
                'title'          => 'Créer un rôle',
            ],

            'edit' => [
                'access-control' => 'Contrôle d\'accès',
                'all'            => 'Tous',
                'back-btn'       => 'Retour',
                'custom'         => 'Personnalisé',
                'description'    => 'Description',
                'general'        => 'Général',
                'name'           => 'Nom',
                'permissions'    => 'Autorisations',
                'save-btn'       => 'Enregistrer le rôle',
                'title'          => 'Éditer le rôle',
            ],

            'being-used'        => 'Le rôle est déjà utilisé par un utilisateur administrateur',
            'create-success'    => 'Rôles créés avec succès',
            'delete-failed'     => 'La suppression des rôles a échoué',
            'delete-success'    => 'Rôles supprimés avec succès',
            'last-delete-error' => 'Le dernier rôle ne peut pas être supprimé',
            'update-success'    => 'Rôles mis à jour avec succès',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Créer un thème',
                'title'      => 'Thèmes',

                'datagrid' => [
                    'active'        => 'Actif',
                    'channel_name'  => 'Nom du canal',
                    'change-status' => 'Changer le statut',
                    'delete'        => 'Supprimer',
                    'id'            => 'ID',
                    'inactive'      => 'Inactif',
                    'name'          => 'Nom',
                    'sort-order'    => 'Ordre de tri',
                    'status'        => 'Statut',
                    'theme'         => 'Thème',
                    'type'          => 'Type',
                    'view'          => 'Voir',
                ],
            ],

            'create' => [
                'name'       => 'Nom',
                'save-btn'   => 'Enregistrer le thème',
                'sort-order' => 'Ordre de tri',
                'themes'     => 'Thèmes',
                'title'      => 'Créer un thème',

                'type' => [
                    'category-carousel' => 'Carrousel de catégorie',
                    'footer-links'      => 'Liens de pied de page',
                    'image-carousel'    => 'Carrousel d\'images',
                    'product-carousel'  => 'Carrousel de produits',
                    'services-content'  => 'Contenu des services',
                    'static-content'    => 'Contenu statique',
                    'title'             => 'Type',
                ],
            ],

            'edit' => [
                'active'                        => 'Actif',
                'add-filter-btn'                => 'Ajouter un filtre',
                'add-footer-link-btn'           => 'Ajouter un lien de pied de page',
                'add-image-btn'                 => 'Ajouter une image',
                'add-link'                      => 'Ajouter un lien',
                'asc'                           => 'Asc',
                'back'                          => 'Retour',
                'category-carousel'             => 'Carrousel de catégorie',
                'category-carousel-description' => 'Affichez les catégories de manière attrayante à l\'aide d\'un carrousel de catégories réactif.',
                'channels'                      => 'Canaux',
                'column'                        => 'Colonne',
                'create-filter'                 => 'Créer un filtre',
                'css'                           => 'CSS',
                'delete'                        => 'Supprimer',
                'desc'                          => 'Desc',
                'edit'                          => 'Éditer',
                'featured'                      => 'En vedette',
                'filter-title'                  => 'Titre',
                'filters'                       => 'Filtres',
                'footer-link'                   => 'Liens de pied de page',
                'footer-link-description'       => 'Naviguez via les liens de pied de page pour une exploration fluide du site Web et des informations.',
                'footer-link-form-title'        => 'Lien de pied de page',
                'footer-title'                  => 'Titre',
                'general'                       => 'Général',
                'html'                          => 'HTML',
                'image'                         => 'Image',
                'image-size'                    => "La résolution de l'image doit être de (1920px x 700px)",
                'image-title'                   => 'Titre de l\'image',
                'image-upload-message'          => 'Seules les images (.jpeg, .jpg, .png, .webp, ..) sont autorisées.',
                'inactive'                      => 'Inactif',
                'key'                           => 'Clé : :key',
                'key-input'                     => 'Clé',
                'limit'                         => 'Limite',
                'link'                          => 'Lien',
                'name'                          => 'Nom',
                'new'                           => 'Nouveau',
                'no'                            => 'Non',
                'parent-id'                     => 'ID Parent',
                'parent-id-hint'                => 'Vous pouvez entrer plusieurs ID parents en tant que valeurs séparées par des virgules (par exemple: 12,15,34)',
                'category-id'                   => 'ID de catégorie',
                'preview'                       => 'Aperçu',
                'product-carousel'              => 'Carrousel de produits',
                'product-carousel-description'  => 'Présentez élégamment des produits avec un carrousel de produits dynamique et réactif.',
                'save-btn'                      => 'Enregistrer',
                'select'                        => 'Sélectionner',
                'slider'                        => 'Curseur',
                'slider-add-btn'                => 'Ajouter un curseur',
                'slider-description'            => 'Personnalisation liée au curseur de thème.',
                'slider-image'                  => 'Image du curseur',
                'slider-required'               => 'Le champ Curseur est requis.',
                'sort'                          => 'Trier',
                'sort-order'                    => 'Ordre de tri',
                'static-content'                => 'Contenu statique',
                'static-content-description'    => 'Améliorez l\'engagement avec un contenu statique concis et informatif pour votre public.',
                'status'                        => 'Statut',
                'themes'                        => 'Thèmes',
                'title'                         => 'Modifier le thème',
                'update-slider'                 => 'Mettre à jour le curseur',
                'url'                           => 'URL',
                'value'                         => 'Valeur : :value',
                'value-input'                   => 'Valeur',

                'services-content' => [
                    'add-btn'               => 'Ajouter des services',
                    'channels'              => 'Canaux',
                    'delete'                => 'Supprimer',
                    'description'           => 'Description',
                    'general'               => 'Général',
                    'name'                  => 'Nom',
                    'save-btn'              => 'Enregistrer',
                    'service-icon'          => 'Icône de service',
                    'service-icon-class'    => 'Classe d\'icône de service',
                    'service-info'          => 'Personnalisation de thèmes liés au service.',
                    'services'              => 'Services',
                    'sort-order'            => 'Ordre de tri',
                    'status'                => 'Statut',
                    'title'                 => 'Titre',
                    'update-service'        => 'Mettre à jour les services',
                ],
                'Yes'                          => 'Oui',
            ],

            'create-success' => 'Thème créé avec succès',
            'delete-success' => 'Thème supprimé avec succès',
            'update-success' => 'Thème mis à jour avec succès',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Paniers abandonnés',
                'abandoned-products'            => 'Produits abandonnés',
                'abandoned-rate'                => 'Taux d\'abandon',
                'abandoned-revenue'             => 'Revenu abandonné',
                'added-to-cart'                 => 'Ajouté au panier',
                'added-to-cart-info'            => 'Seuls :progress visiteurs ont ajouté des produits au panier',
                'all-channels'                  => 'Tous les canaux',
                'average-order-value-over-time' => 'Valeur moyenne de la commande dans le temps',
                'average-sales'                 => 'Valeur moyenne de la commande',
                'count'                         => 'Nombre',
                'end-date'                      => 'Date de fin',
                'id'                            => 'ID',
                'interval'                      => 'Intervalle',
                'name'                          => 'Nom',
                'orders'                        => 'Commandes',
                'orders-over-time'              => 'Commandes dans le temps',
                'payment-method'                => 'Moyen de paiement',
                'product-views'                 => 'Vues de produits',
                'product-views-info'            => 'Seuls :progress visiteurs consultent des produits',
                'purchase-funnel'               => 'Entonnoir d\'achat',
                'purchased'                     => 'Achats',
                'purchased-info'                => 'Seuls :progress visiteurs effectuent des achats',
                'refunds'                       => 'Remboursements',
                'refunds-over-time'             => 'Remboursements dans le temps',
                'sales-over-time'               => 'Ventes dans le temps',
                'shipping-collected'            => 'Frais d\'expédition collectés',
                'shipping-collected-over-time'  => 'Frais d\'expédition collectés dans le temps',
                'start-date'                    => 'Date de début',
                'tax-collected'                 => 'Taxes collectées',
                'tax-collected-over-time'       => 'Taxes collectées dans le temps',
                'title'                         => 'Ventes',
                'top-payment-methods'           => 'Meilleurs moyens de paiement',
                'top-shipping-methods'          => 'Meilleurs moyens de livraison',
                'top-tax-categories'            => 'Meilleures catégories fiscales',
                'total'                         => 'Total',
                'total-orders'                  => 'Total des commandes',
                'total-sales'                   => 'Total des ventes',
                'total-visits'                  => 'Total des visites',
                'total-visits-info'             => 'Total des visiteurs sur le site',
                'view-details'                  => 'Voir les détails',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Tous les canaux',
                'count'                       => 'Nombre',
                'customers'                   => 'Clients',
                'customers-over-time'         => 'Clients dans le temps',
                'customers-traffic'           => 'Trafic des clients',
                'customers-with-most-orders'  => 'Clients avec le plus de commandes',
                'customers-with-most-reviews' => 'Clients avec le plus d\'avis',
                'customers-with-most-sales'   => 'Clients avec le plus de ventes',
                'email'                       => 'E-mail',
                'end-date'                    => 'Date de fin',
                'id'                          => 'ID',
                'interval'                    => 'Intervalle',
                'name'                        => 'Nom',
                'orders'                      => 'Commandes',
                'reviews'                     => 'Avis',
                'start-date'                  => 'Date de début',
                'title'                       => 'Clients',
                'top-customer-groups'         => 'Meilleurs groupes de clients',
                'total'                       => 'Total',
                'total-customers'             => 'Total des clients',
                'total-visitors'              => 'Total des visiteurs',
                'traffic-over-week'           => 'Trafic sur la semaine',
                'unique-visitors'             => 'Visiteurs uniques',
                'view-details'                => 'Voir les détails',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Tous les canaux',
                'channel'                          => 'Canal',
                'end-date'                         => 'Date de fin',
                'id'                               => 'ID',
                'interval'                         => 'Intervalle',
                'last-search-terms'                => 'Derniers termes de recherche',
                'locale'                           => 'Locale',
                'name'                             => 'Nom',
                'orders'                           => 'Commandes',
                'price'                            => 'Prix',
                'products-added-over-time'         => 'Produits ajoutés dans le temps',
                'products-with-most-reviews'       => 'Produits avec le plus d\'avis',
                'products-with-most-visits'        => 'Produits avec le plus de visites',
                'quantities'                       => 'Quantités',
                'quantities-sold-over-time'        => 'Quantités vendues dans le temps',
                'results'                          => 'Résultats',
                'revenue'                          => 'Revenu',
                'reviews'                          => 'Avis',
                'search-term'                      => 'Terme de recherche',
                'start-date'                       => 'Date de début',
                'title'                            => 'Produits',
                'top-search-terms'                 => 'Termes de recherche les plus populaires',
                'top-selling-products-by-quantity' => 'Meilleurs produits vendus par quantité',
                'top-selling-products-by-revenue'  => 'Meilleurs produits vendus par revenu',
                'total'                            => 'Total',
                'total-products-added-to-wishlist' => 'Produits ajoutés à la liste de souhaits',
                'total-sold-quantities'            => 'Quantités de produits vendues',
                'uses'                             => 'Utilisations',
                'view-details'                     => 'Voir les détails',
                'visits'                           => 'Visites',
            ],
        ],

        'view' => [
            'all-channels'  => 'Tous les canaux',
            'back-btn'      => 'Retour',
            'day'           => 'Jour',
            'end-date'      => 'Date de fin',
            'export-csv'    => 'Exporter en CSV',
            'export-xls'    => 'Exporter en XLS',
            'month'         => 'Mois',
            'not-available' => 'Aucun enregistrement disponible.',
            'start-date'    => 'Date de début',
            'year'          => 'Année',
        ],

        'empty' => [
            'info'  => 'Aucune donnée disponible pour la période sélectionnée',
            'title' => 'Aucune donnée disponible',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => 'Retour',
            'delete'                       => 'Supprimer',
            'enable-at-least-one-payment'  => 'Activer au moins une méthode de paiement.',
            'enable-at-least-one-shipping' => 'Activer au moins une méthode d\'expédition.',
            'no-result-found'              => 'Aucun résultat trouvé',
            'save-btn'                     => 'Enregistrer la configuration',
            'save-message'                 => 'Configuration enregistrée avec succès',
            'search'                       => 'Rechercher',
            'select-country'               => 'Sélectionner un pays',
            'select-state'                 => 'Sélectionner un état',
            'title'                        => 'Configuration',

            'general' => [
                'info'  => 'Définir les options d\'unités.',
                'title' => 'Général',

                'general' => [
                    'info'  => 'Configurer les paramètres d\'unités et activer ou désactiver les options Fil d\'Ariane et Visiteur.',
                    'title' => 'Général',

                    'unit-options' => [
                        'info'        => 'Définir les options d\'unités.',
                        'title'       => 'Options d\'unité',
                        'title-info'  => 'Configurez le poids en livres (lbs) ou en kilogrammes (kgs).',
                        'weight-unit' => 'Unité de poids',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Fil d\'Ariane de la boutique',
                        'title'      => 'Fil d\'Ariane',
                        'title-info' => 'Activer ou désactiver la navigation par fil d\'Ariane dans la boutique.',
                    ],

                    'visitor-options' => [
                        'enable'     => 'Activer les options de visiteur',
                        'title'      => 'Options de visiteur',
                        'title-info' => 'Permet de contrôler le site pour suivre et compter le nombre de visites, aidant à surveiller l\'activité générale et l\'engagement des visiteurs.',
                    ],
                ],

                'content' => [
                    'info'  => 'Définir le titre de l\'offre d\'en-tête et les scripts personnalisés.',
                    'title' => 'Contenu',

                    'header-offer' => [
                        'title'             => 'Titre de l\'offre d\'en-tête',
                        'title-info'        => 'Configurer le titre de l\'offre d\'en-tête avec le titre de l\'offre, le titre de redirection et le lien de redirection.',
                        'offer-title'       => 'Titre de l\'offre',
                        'redirection-title' => 'Titre de redirection',
                        'redirection-link'  => 'Lien de redirection',
                    ],

                    'speculation-rules' => [
                        'enable-speculation' => 'Activer les règles de spéculation',
                        'info'               => 'Configurer les paramètres pour activer ou désactiver la logique de spéculation automatique.',
                        'title'              => 'Règles de spéculation',

                        'prerender' => [
                            'conservative'           => 'Conservateur',
                            'eager'                  => 'Avide',
                            'eagerness'              => 'Niveau d’empressement du Prerender',
                            'eagerness-info'         => 'Contrôle l’agressivité d’application des règles de spéculation. Options : avide (max), modéré (par défaut), conservateur (faible).',
                            'enabled'                => 'Activer les règles de spéculation Prerender',
                            'ignore-url-params'      => 'Ignorer les paramètres d’URL pour Prerender',
                            'ignore-url-params-info' => 'Spécifiez les paramètres d’URL à ignorer dans les règles de spéculation. Utilisez le caractère pipe (|) pour en séparer plusieurs.',
                            'ignore-urls'            => 'Ignorer les URLs de Prerender',
                            'ignore-urls-info'       => 'Entrez les URLs à exclure de la logique de spéculation. Séparez-les avec un caractère pipe (|).',
                            'info'                   => 'Définir le statut des règles de spéculation.',
                            'moderate'               => 'Modéré',
                        ],

                        'prefetch' => [
                            'conservative'           => 'Conservateur',
                            'eager'                  => 'Avide',
                            'eagerness'              => 'Niveau d’empressement du Prefetch',
                            'eagerness-info'         => 'Contrôle l’agressivité d’application des règles de spéculation. Options : avide (max), modéré (par défaut), conservateur (faible).',
                            'enabled'                => 'Activer les règles de spéculation Prefetch',
                            'ignore-url-params'      => 'Ignorer les paramètres d’URL pour Prefetch',
                            'ignore-url-params-info' => 'Spécifiez les paramètres d’URL à ignorer dans les règles de spéculation. Utilisez le caractère pipe (|) pour en séparer plusieurs.',
                            'ignore-urls'            => 'Ignorer les URLs de Prefetch',
                            'ignore-urls-info'       => 'Entrez les URLs à exclure de la logique de spéculation. Séparez-les avec un caractère pipe (|).',
                            'info'                   => 'Définir le statut des règles de spéculation.',
                            'moderate'               => 'Modéré',
                        ],
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'CSS personnalisé',
                        'custom-javascript' => 'Javascript personnalisé',
                        'title'             => 'Scripts personnalisés',
                        'title-info'        => 'Les scripts personnalisés sont des morceaux de code personnalisés créés pour ajouter des fonctions ou des fonctionnalités spécifiques à un logiciel, améliorant ainsi ses capacités de manière unique.',
                    ],
                ],

                'design' => [
                    'info'  => 'Définir le logo et l\'icône favicon pour le panneau d\'administration.',
                    'title' => 'Design',

                    'admin-logo' => [
                        'favicon'    => 'Favicon',
                        'logo-image' => 'Image du logo',
                        'title'      => 'Logo de l\'administrateur',
                        'title-info' => 'Configurez les images du logo et du favicon pour la partie frontale de votre site web afin d\'améliorer votre image de marque et votre reconnaissance.',
                    ],

                    'menu-category' => [
                        'default'         => 'Menu par défaut',
                        'info'            => 'Ce paramètre contrôle la visibilité des catégories dans le menu d’en-tête. Vous pouvez choisir d’afficher uniquement les catégories parentes ou toutes les catégories imbriquées.',
                        'preview-default' => 'Aperçu du menu par défaut',
                        'preview-sidebar' => 'Aperçu du menu latéral',
                        'sidebar'         => 'Menu latéral',
                        'title'           => 'Vue de la catégorie du menu',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Définir les options Magic AI et permettre certaines options pour automatiser la création de contenu.',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'Clé API',
                        'enabled'        => 'Activé',
                        'llm-api-domain' => 'Domaine de l\'API LLM',
                        'organization'   => 'Organisation',
                        'title'          => 'Paramètres généraux',
                        'title-info'     => 'Améliorez votre expérience avec la fonctionnalité Magic AI en entrant votre clé API exclusive et en indiquant l\'organisation pertinente pour une intégration sans effort. Prenez le contrôle de vos informations d\'identification OpenAI et personnalisez les paramètres en fonction de vos besoins spécifiques.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Invite de description de catégorie',
                        'cms-page-content-prompt'          => 'Invite de contenu de page CMS',
                        'enabled'                          => 'Activé',
                        'product-description-prompt'       => 'Invite de description de produit',
                        'product-short-description-prompt' => 'Invite de description courte du produit',
                        'title'                            => 'Génération de contenu',
                        'title-info'                       => 'Cette fonctionnalité permet d\'activer la Magic AI pour chaque éditeur WYSIWYG, où vous souhaitez gérer le contenu à l\'aide de l\'IA.<br/><br/>Lorsqu\'elle est activée, accédez à n\'importe quel éditeur pour générer du contenu.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Activé',
                        'title'      => 'Génération d\'images',
                        'title-info' => 'Cette fonctionnalité permet d\'activer la Magic AI pour chaque téléchargement d\'image, où vous souhaitez générer des images à l\'aide de DALL-E.<br/><br/>Lorsqu\'elle est activée, accédez à n\'importe quel téléchargement d\'image pour générer une image.',
                    ],

                    'review-translation' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Activé',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt-4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modèle',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Traduction des avis',
                        'title-info'          => 'Fournir une option au client ou au visiteur pour traduire l\'avis client en anglais.<br/><br/>Lorsque activé, allez à l\'avis et vous trouverez le bouton "Traduire en anglais" si vous consultez un avis autre que l\'anglais.',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],

                    'checkout-message' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Activé',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt 4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modèle',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'prompt'              => 'Invite',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Message de validation personnalisé',
                        'title-info'          => 'Créez un message de validation personnalisé pour les clients sur la page de remerciement, en adaptant le contenu pour résonner avec les préférences individuelles et améliorer l\'expérience post-achat globale.',
                        'vicuna'              => 'Vicuna',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],
                ],

                'gdpr' => [
                    'title' => 'GDPR',
                    'info'  => 'Paramètres de conformité au GDPR',

                    'settings' => [
                        'title'   => 'Paramètres de conformité au GDPR',
                        'info'    => 'Gérer les paramètres de conformité au GDPR, y compris la politique de confidentialité. Activer ou désactiver les fonctionnalités du GDPR selon les besoins.',
                        'enabled' => 'Activer le GDPR',
                    ],

                    'agreement' => [
                        'title'          => 'Accord GDPR',
                        'info'           => 'Gérer le consentement des clients conformément aux réglementations GDPR. Activer le consentement obligatoire pour la collecte et le traitement des données.',
                        'enable'         => 'Activer le consentement des clients',
                        'checkbox-label' => 'Étiquette de la case à cocher pour le consentement',
                        'content'        => 'Contenu du consentement',
                    ],

                    'cookie' => [
                        'bottom-left'  => 'En bas à gauche',
                        'bottom-right' => 'En bas à droite',
                        'center'       => 'Centre',
                        'description'  => 'Description',
                        'enable'       => 'Activer la notification des cookies',
                        'identifier'   => 'Identifiant du bloc statique',
                        'info'         => 'Configurer les paramètres de consentement des cookies pour informer les utilisateurs de la collecte de données et se conformer aux politiques de confidentialité.',
                        'position'     => 'Position d\'affichage du bloc de cookies',
                        'title'        => 'Paramètres de notification des cookies',
                        'top-left'     => 'En haut à gauche',
                        'top-right'    => 'En haut à droite',
                    ],

                    'cookie-consent' => [
                        'title'                  => 'Gérer vos paramètres de cookies',
                        'info'                   => 'Contrôlez comment vos données sont utilisées en sélectionnant les paramètres de cookies souhaités. Configurez les autorisations pour différents types de cookies.',
                        'strictly-necessary'     => 'Strictement nécessaire',
                        'basic-interaction'      => 'Interaction et fonctionnalité de base',
                        'experience-enhancement' => 'Amélioration de l\'expérience',
                        'measurement'            => 'Mesure',
                        'targeting-advertising'  => 'Ciblage et publicité',
                    ],
                ],

                'sitemap' => [
                    'info'  => 'Configurer les options du plan du site.',
                    'title' => 'Plan du Site',

                    'settings' => [
                        'enabled' => 'Activé',
                        'info'    => 'Activer ou désactiver le plan du site pour votre site web afin d\'améliorer le référencement et d\'améliorer l\'expérience utilisateur.',
                        'title'   => 'Paramètres',
                    ],

                    'file-limits' => [
                        'info'             => 'Configurer les options de limites de fichier.',
                        'max-file-size'    => 'Taille maximale du fichier',
                        'max-url-per-file' => 'Nombre maximal d\'URL par fichier',
                        'title'            => 'Limites de Fichier',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Catalogue',
                'title' => 'Catalogue',

                'products' => [
                    'info'  => 'Page de vue produit, page de vue panier, vitrine, avis et partage social des attributs.',
                    'title' => 'Produits',

                    'settings' => [
                        'compare-options'     => 'Options de comparaison',
                        'image-search-option' => 'Option de recherche d\'image',
                        'title'               => 'Paramètres',
                        'title-info'          => 'Les paramètres font référence aux choix configurables qui contrôlent le comportement d\'un système, d\'une application ou d\'un appareil, adaptés aux préférences et aux exigences de l\'utilisateur.',
                        'wishlist-options'    => 'Options de liste de souhaits',
                    ],

                    'search' => [
                        'admin-mode'            => 'Mode de recherche administrateur',
                        'admin-mode-info'       => 'La recherche méga, la grille de données et autres fonctionnalités de recherche dans le panneau d\'administration seront basées sur le moteur de recherche sélectionné.',
                        'database'              => 'Base de données',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Longueur maximale de la requête',
                        'max-query-length-info' => 'Définissez la longueur maximale de la requête pour les recherches.',
                        'min-query-length'      => 'Longueur minimale de la requête',
                        'min-query-length-info' => 'Définissez la longueur minimale de la requête pour les recherches.',
                        'search-engine'         => 'Moteur de recherche',
                        'storefront-mode'       => 'Mode de recherche de la vitrine',
                        'storefront-mode-info'  => 'La fonctionnalité de recherche sur la vitrine sera basée sur le moteur de recherche sélectionné, y compris la page de catégorie, la page de recherche et autres fonctionnalités de recherche.',
                        'title'                 => 'Recherche',
                        'title-info'            => 'Pour configurer le moteur de recherche pour les recherches de produits, vous pouvez choisir entre une base de données et Elasticsearch en fonction de vos besoins. Si vous avez un grand nombre de produits, Elasticsearch est recommandé.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Autoriser la validation des invités',
                        'allow-guest-checkout-hint' => 'Astuce : si activé, cette option peut être configurée pour chaque produit spécifiquement.',
                        'title'                     => 'Validation des invités',
                        'title-info'                => 'La validation des invités permet aux clients d\'acheter des produits sans créer de compte, simplifiant le processus d\'achat pour plus de commodité et de rapidité.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Nombre autorisé de produits associés',
                        'allow-no-of-up-sells-products' => 'Nombre autorisé de produits de vente croisée',
                        'title'                         => 'Configuration de la page de visualisation du produit',
                        'title-info'                    => 'La configuration de la page de visualisation du produit consiste à ajuster la mise en page et les éléments sur la page d\'affichage d\'un produit, améliorant ainsi l\'expérience utilisateur et la présentation des informations.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Nombre autorisé de produits de vente croisée',
                        'title'                            => 'Configuration de la page de visualisation du panier',
                        'title-info'                       => 'La configuration de la page de visualisation du panier consiste à organiser les articles, les détails et les options sur la page du panier d\'achat, améliorant ainsi l\'interaction de l\'utilisateur et le flux d\'achat.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Permettre aux clients d\'acheter directement des produits',
                        'cheapest-first'         => 'Le moins cher en premier',
                        'comma-separated'        => 'Séparé par des virgules',
                        'default-list-mode'      => 'Mode de liste par défaut',
                        'expensive-first'        => 'Le plus cher en premier',
                        'from-a-z'               => 'De A à Z',
                        'from-z-a'               => 'De Z à A',
                        'grid'                   => 'Grille',
                        'latest-first'           => 'Le plus récent en premier',
                        'list'                   => 'Liste',
                        'oldest-first'           => 'Le plus ancien en premier',
                        'products-per-page'      => 'Produits par page',
                        'sort-by'                => 'Trier par',
                        'title'                  => 'Vitrine',
                        'title-info'             => 'La vitrine est l\'interface orientée client d\'une boutique en ligne, présentant des produits, des catégories et une navigation pour une expérience d\'achat fluide.',
                    ],

                    'small-image' => [
                        'height'      => 'Hauteur',
                        'placeholder' => 'Emplacement réservé pour les petites images',
                        'title'       => 'Petite image',
                        'title-info'  => 'La vitrine est l\'interface orientée client d\'une boutique en ligne, présentant des produits, des catégories et une navigation pour une expérience d\'achat fluide.',
                        'width'       => 'Largeur',
                    ],

                    'medium-image' => [
                        'height'      => 'Hauteur',
                        'placeholder' => 'Emplacement réservé pour les images moyennes',
                        'title'       => 'Image moyenne',
                        'title-info'  => 'L\'image moyenne fait référence à une image de taille modérée qui offre un équilibre entre les détails et l\'espace à l\'écran, couramment utilisée pour les visuels.',
                        'width'       => 'Largeur',
                    ],

                    'large-image' => [
                        'height'      => 'Hauteur',
                        'placeholder' => 'Emplacement réservé pour les grandes images',
                        'title'       => 'Grande image',
                        'title-info'  => 'La grande image représente une image haute résolution offrant des détails et un impact visuel améliorés, souvent utilisée pour présenter des produits ou des graphiques.',
                        'width'       => 'Largeur',
                    ],

                    'review' => [
                        'allow-customer-review'   => 'Autoriser les avis des clients',
                        'allow-guest-review'      => 'Autoriser les avis des invités',
                        'censoring-reviewer-name' => 'Censurer le nom du critique',
                        'display-review-count'    => 'Affichez le nombre d\'avis pour les notes.',
                        'display-star-count'      => 'Affichez le nombre d\'étoiles dans les notes.',
                        'summary'                 => 'Résumé',
                        'title'                   => 'Avis',
                        'title-info'              => 'Évaluation ou évaluation de quelque chose, impliquant souvent des opinions et des commentaires.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Taille de téléchargement de fichier autorisée (en Ko)',
                        'image-upload-size' => 'Taille de téléchargement d\'image autorisée (en Ko)',
                        'title'             => 'Attribut',
                        'title-info'        => 'Caractéristique ou propriété qui définit un objet, influençant son comportement, son apparence ou sa fonction.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Configurez les paramètres de partage social pour permettre le partage de produits sur Instagram, Twitter, WhatsApp, Facebook, Pinterest, LinkedIn et par e-mail.',
                        'title'                       => 'Partage social',
                        'share-message'               => 'Message de partage',
                        'share'                       => 'Partager',
                        'enable-social-share'         => 'Activer le partage social ?',
                        'enable-share-whatsapp-info'  => 'Le lien de partage de WhatsApp n\'apparaîtra que sur les appareils mobiles.',
                        'enable-share-whatsapp'       => 'Activer le partage sur WhatsApp ?',
                        'enable-share-twitter'        => 'Activer le partage sur Twitter ?',
                        'enable-share-pinterest'      => 'Activer le partage sur Pinterest ?',
                        'enable-share-linkedin'       => 'Activer le partage sur LinkedIn ?',
                        'enable-share-facebook'       => 'Activer le partage sur Facebook ?',
                        'enable-share-email'          => 'Activer le partage par e-mail ?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Définissez les produits et les catégories.',
                    'title' => 'Extraits enrichis',

                    'products' => [
                        'enable'          => 'Activer',
                        'show-categories' => 'Afficher les catégories',
                        'show-images'     => 'Afficher les images',
                        'show-offers'     => 'Afficher les offres',
                        'show-ratings'    => 'Afficher les évaluations',
                        'show-reviews'    => 'Afficher les avis',
                        'show-sku'        => 'Afficher le SKU',
                        'show-weight'     => 'Afficher le poids',
                        'title'           => 'Produits',
                        'info'            => 'Configurer les options de stock du produit pour autoriser les commandes en attente, définir les quantités minimales et maximales dans le panier, et définir les seuils de rupture de stock.',
                    ],

                    'categories' => [
                        'enable'                  => 'Activer',
                        'show-search-input-field' => 'Afficher le champ de recherche',
                        'title'                   => 'Catégories',
                        'title-info'              => 'Les "catégories" désignent des groupes ou des classifications qui aident à organiser et à regrouper des produits ou des articles similaires pour une navigation et une recherche plus faciles.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Inventaire',
                    'title-info' => 'Configurer les paramètres d\'inventaire pour autoriser les commandes en attente et définir le seuil de rupture de stock.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Autoriser les commandes en attente',
                        'max-qty-allowed-in-cart' => 'Quantité maximale autorisée dans le panier',
                        'min-qty-allowed-in-cart' => 'Quantité minimale autorisée dans le panier',
                        'out-of-stock-threshold'  => 'Seuil de rupture de stock',
                        'title'                   => 'Option de stock de produit',
                        'info'                    => 'Configurez les options de stock de produit pour autoriser les commandes en attente, définir les quantités minimales et maximales du panier, et définir les seuils de rupture de stock.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Client',
                'title' => 'Client',

                'address' => [
                    'info'  => 'Définir le pays, l\'état, le code postal et les lignes d\'une adresse.',
                    'title' => 'Adresse',

                    'requirements' => [
                        'city'       => 'Ville',
                        'country'    => 'Pays',
                        'state'      => 'État',
                        'title'      => 'Exigences',
                        'title-info' => 'Les exigences sont les conditions, caractéristiques ou spécifications nécessaires pour que quelque chose soit rempli, réalisé ou atteint avec succès.',
                        'zip'        => 'Code postal',
                    ],

                    'information' => [
                        'street-lines' => 'Lignes dans une adresse',
                        'title'        => 'Informations',
                        'title-info'   => '"Lignes dans une adresse" font référence aux segments individuels d\'une adresse, souvent séparés par des virgules, fournissant des informations de localisation telles que le numéro de maison, la rue, la ville, et plus encore.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Définir la clé du site, la clé secrète et le statut.',
                    'title' => 'Google Captcha',

                    'credentials' => [
                        'secret-key' => 'Clé secrète',
                        'site-key'   => 'Clé du site',
                        'status'     => 'Statut',
                        'title'      => 'Informations d\'identification',
                        'title-info' => '"Sitemap: Plan du site Web pour les moteurs de recherche. Clé secrète: Code sécurisé pour le chiffrement des données, l\'authentification ou la protection de l\'accès à l\'API."',
                    ],

                    'validations' => [
                        'captcha'  => 'Quelque chose s\'est mal passé! Veuillez réessayer.',
                        'required' => 'Veuillez sélectionner CAPTCHA',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Définir la liste de souhaits, la redirection de connexion, les abonnements à la newsletter, l\'option de groupe par défaut, les vérifications par e-mail et la connexion sociale.',
                    'title'         => 'Paramètres',

                    'login-as-customer' => [
                        'allow-option' => 'Autoriser la connexion en tant que client',
                        'title'        => 'Connexion en tant que client',
                        'title-info'   => 'Activer la fonctionnalité "Connexion en tant que client".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Autoriser l\'option de liste de souhaits',
                        'title'        => 'Liste de souhaits',
                        'title-info'   => 'Activer ou désactiver l\'option de liste de souhaits.',
                    ],

                    'login-options' => [
                        'account'          => 'Compte',
                        'home'             => 'Accueil',
                        'redirect-to-page' => 'Rediriger le client vers la page sélectionnée',
                        'title'            => 'Options de connexion',
                        'title-info'       => 'Configurer les options de connexion pour déterminer la page de redirection des clients après la connexion.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Autoriser la newsletter',
                        'news-letter-info' => 'Activer l\'option d\'abonnement à la newsletter sur la page d\'inscription.',
                        'title'            => 'Options de création de compte',
                        'title-info'       => 'Définir les options pour les nouveaux comptes, y compris l\'attribution d\'un groupe de clients par défaut et l\'activation de l\'option d\'abonnement à la newsletter lors de l\'inscription.',

                        'default-group' => [
                            'general'    => 'Général',
                            'guest'      => 'Invité',
                            'title'      => 'Groupe par défaut',
                            'title-info' => 'Attribuer un groupe de clients spécifique comme groupe par défaut pour les nouveaux clients.',
                            'wholesale'  => 'En gros',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Autoriser l\'abonnement à la newsletter',
                        'title'        => 'Abonnement à la newsletter',
                        'title-info'   => '"Informations sur la newsletter" contient des mises à jour, des offres ou du contenu partagé régulièrement par e-mail aux abonnés, les tenant informés et engagés.',
                    ],

                    'email' => [
                        'email-verification' => 'Autoriser la vérification par e-mail',
                        'title'              => 'Vérification par e-mail',
                        'title-info'         => '"La vérification par e-mail" confirme l\'authenticité d\'une adresse e-mail, souvent en envoyant un lien de confirmation, améliorant ainsi la sécurité du compte et la fiabilité de la communication.',
                    ],

                    'social-login' => [
                        'title' => 'Connexion sociale',
                        'info'  => 'La "connexion sociale" permet aux utilisateurs d’accéder à un site Web à l’aide de leurs comptes de réseaux sociaux, simplifiant ainsi les processus d’inscription et de connexion.',

                        'google' => [
                            'enable-google' => 'Activer Google',

                            'client-id' => [
                                'title'      => 'Identifiant client',
                                'title-info' => 'Identifiant unique fourni par Google lors de la création de votre application OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Clé secrète du client',
                                'title-info' => 'Clé secrète associée à votre client OAuth Google. Gardez-la confidentielle.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirection',
                                'title-info' => 'URL de rappel vers laquelle les utilisateurs sont redirigés après l’authentification avec Google. Elle doit correspondre à l’URL configurée dans votre console Google.',
                            ],
                        ],

                        'facebook' => [
                            'enable-facebook' => 'Activer Facebook',

                            'client-id' => [
                                'title'      => 'Identifiant client',
                                'title-info' => 'ID d’application fourni par Facebook lors de la création d’une application dans la console développeur Facebook.',
                            ],

                            'client-secret' => [
                                'title'      => 'Clé secrète du client',
                                'title-info' => 'Clé secrète associée à votre application Facebook. Gardez-la sécurisée et privée.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirection',
                                'title-info' => 'URL de rappel vers laquelle les utilisateurs sont redirigés après l’authentification avec Facebook. Elle doit correspondre à l’URL configurée dans les paramètres de votre application Facebook.',
                            ],
                        ],

                        'github' => [
                            'enable-github' => 'Activer GitHub',

                            'client-id' => [
                                'title'      => 'Identifiant client',
                                'title-info' => 'Identifiant unique fourni par GitHub lors de la création de votre application OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Clé secrète du client',
                                'title-info' => 'Clé secrète associée à votre client OAuth GitHub. Gardez-la confidentielle.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirection',
                                'title-info' => 'URL de rappel vers laquelle les utilisateurs sont redirigés après l’authentification avec GitHub. Elle doit correspondre à l’URL configurée dans votre console GitHub.',
                            ],
                        ],

                        'linkedin' => [
                            'enable-linkedin' => 'Activer LinkedIn',

                            'client-id' => [
                                'title'      => 'Identifiant client',
                                'title-info' => 'Identifiant unique fourni par LinkedIn lors de la création de votre application OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Clé secrète du client',
                                'title-info' => 'Clé secrète associée à votre client OAuth LinkedIn. Gardez-la confidentielle.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirection',
                                'title-info' => 'URL de rappel vers laquelle les utilisateurs sont redirigés après l’authentification avec LinkedIn. Elle doit correspondre à l’URL configurée dans votre console LinkedIn.',
                            ],
                        ],

                        'twitter' => [
                            'enable-twitter' => 'Activer Twitter',

                            'client-id' => [
                                'title'      => 'Identifiant client',
                                'title-info' => 'Identifiant unique fourni par Twitter lors de la création de votre application OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Clé secrète du client',
                                'title-info' => 'Clé secrète associée à votre client OAuth Twitter. Gardez-la confidentielle.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirection',
                                'title-info' => 'URL de rappel vers laquelle les utilisateurs sont redirigés après l’authentification avec Twitter. Elle doit correspondre à l’URL configurée dans votre console Twitter.',
                            ],
                        ],
                    ],
                ],
            ],

            'email' => [
                'info'  => 'Email',
                'title' => 'Email',

                'email-settings' => [
                    'admin-email'           => 'Email de l\'administrateur',
                    'admin-email-tip'       => 'L\'adresse e-mail de l\'administrateur de cette chaîne pour recevoir des e-mails',
                    'admin-name'            => 'Nom de l\'administrateur',
                    'admin-name-tip'        => 'Ce nom sera affiché dans tous les e-mails de l\'administrateur',
                    'admin-page-limit'      => 'Nombre d\'éléments par page par défaut (Admin)',
                    'contact-email'         => 'E-mail de contact',
                    'contact-email-tip'     => 'L\'adresse e-mail sera affichée en bas de vos e-mails',
                    'contact-name'          => 'Nom de contact',
                    'contact-name-tip'      => 'Ce nom sera affiché en bas de vos e-mails',
                    'email-sender-name'     => 'Nom de l\'expéditeur des e-mails',
                    'email-sender-name-tip' => 'Ce nom sera affiché dans la boîte de réception des clients',
                    'info'                  => 'Définissez le nom de l\'expéditeur des e-mails, l\'adresse e-mail de la boutique, le nom de l\'administrateur et l\'adresse e-mail de l\'administrateur.',
                    'shop-email-from'       => 'Adresse e-mail de la boutique',
                    'shop-email-from-tip'   => 'L\'adresse e-mail de cette chaîne pour envoyer des e-mails à vos clients',
                    'title'                 => 'Paramètres des e-mails',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Envoyer une notification au client après l\'annulation d\'une commande',
                    'cancel-order-mail-to-admin'                       => 'Envoyer un e-mail de notification à l\'administrateur après l\'annulation d\'une commande',
                    'customer'                                         => 'Envoyer les identifiants du compte client après l\'inscription',
                    'customer-registration-confirmation-mail-to-admin' => 'Envoyer un e-mail de confirmation à l\'administrateur après l\'inscription d\'un client',
                    'info'                                             => 'Pour configurer, recevoir des e-mails pour la vérification de compte, les confirmations de commande, les mises à jour sur les factures, les remboursements, les expéditions et les annulations de commande.',
                    'new-inventory-source'                             => 'Envoyer un e-mail de notification à la source d\'inventaire après la création d\'une expédition',
                    'new-invoice'                                      => 'Envoyer un e-mail de notification au client après la création d\'une nouvelle facture',
                    'new-invoice-mail-to-admin'                        => 'Envoyer un e-mail de notification à l\'administrateur après la création d\'une nouvelle facture',
                    'new-order'                                        => 'Envoyer un e-mail de confirmation au client après avoir passé une nouvelle commande',
                    'new-order-mail-to-admin'                          => 'Envoyer un e-mail de confirmation à l\'administrateur après avoir passé une nouvelle commande',
                    'new-refund'                                       => 'Envoyer un e-mail de notification au client après la création d\'un remboursement',
                    'new-refund-mail-to-admin'                         => 'Envoyer un e-mail de notification à l\'administrateur après la création d\'un nouveau remboursement',
                    'new-shipment'                                     => 'Envoyer un e-mail de notification au client après la création d\'une expédition',
                    'new-shipment-mail-to-admin'                       => 'Envoyer un e-mail de notification à l\'administrateur après la création d\'une nouvelle expédition',
                    'registration'                                     => 'Envoyer un e-mail de confirmation après l\'inscription du client',
                    'title'                                            => 'Notifications',
                    'verification'                                     => 'Envoyer un e-mail de vérification après l\'inscription du client',
                ],
            ],

            'sales' => [
                'info'  => 'Sales',
                'title' => 'Sales',

                'shipping-setting' => [
                    'info'  => 'Configurer les paramètres d\'expédition, y compris le pays, l\'état, la ville, l\'adresse, le code postal, le nom du magasin, le numéro de TVA et les coordonnées bancaires.',
                    'title' => 'Paramètres d\'expédition',

                    'origin' => [
                        'bank-details'   => 'Coordonnées bancaires',
                        'city'           => 'Ville',
                        'contact-number' => 'Numéro de contact',
                        'country'        => 'Pays',
                        'state'          => 'État',
                        'store-name'     => 'Nom du magasin',
                        'street-address' => 'Adresse',
                        'title'          => 'Origine',
                        'title-info'     => 'L\'origine de l\'expédition fait référence à l\'endroit où les marchandises ou les produits sont originaires avant d\'être transportés vers leur destination.',
                        'vat-number'     => 'Numéro de TVA',
                        'zip'            => 'Code postal',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Configurer les méthodes d\'expédition, y compris la livraison gratuite, le tarif fixe et d\'autres options si nécessaire.',
                    'title' => 'Méthodes d\'expédition',

                    'free-shipping' => [
                        'description' => 'Description',
                        'page-title'  => 'Livraison gratuite',
                        'status'      => 'Statut',
                        'title'       => 'Titre',
                        'title-info'  => '"Livraison gratuite" fait référence à une méthode d\'expédition où les frais de livraison sont annulés et le vendeur prend en charge les frais d\'expédition pour livrer les marchandises à l\'acheteur.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Description',
                        'page-title'  => 'Livraison à tarif fixe',
                        'rate'        => 'Tarif',
                        'status'      => 'Statut',
                        'title'       => 'Titre',
                        'title-info'  => 'La livraison à tarif fixe est une méthode d\'expédition où des frais fixes sont facturés pour l\'expédition, indépendamment du poids, de la taille ou de la distance du colis. Cela simplifie les coûts d\'expédition et peut être avantageux pour les acheteurs et les vendeurs.',
                        'type'        => [
                            'per-order' => 'Par commande',
                            'per-unit'  => 'Par unité',
                            'title'     => 'Type',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Devises acceptées',
                    'accepted-currencies-info'       => 'Ajoutez les codes de devise séparés par des virgules, par exemple USD, INR, ...',
                    'business-account'               => 'Compte professionnel',
                    'cash-on-delivery'               => 'Paiement à la livraison',
                    'cash-on-delivery-info'          => 'Méthode de paiement où les clients paient en espèces à la réception des marchandises ou des services à leur porte.',
                    'client-id'                      => 'ID client',
                    'client-id-info'                 => 'Utilisez "sb" pour les tests.',
                    'client-secret'                  => 'Secret client',
                    'client-secret-info'             => 'Ajoutez votre clé secrète ici',
                    'description'                    => 'Description',
                    'generate-invoice'               => 'Générer automatiquement la facture après avoir passé une commande',
                    'generate-invoice-applicable'    => 'Applicable si la génération automatique de facture est activée',
                    'info'                           => 'Définir les informations des méthodes de paiement',
                    'instructions'                   => 'Instructions',
                    'logo'                           => 'Logo',
                    'logo-information'               => 'La résolution de l\'image doit être de 55px x 45px',
                    'mailing-address'                => 'Envoyer le chèque à',
                    'money-transfer'                 => 'Virement bancaire',
                    'money-transfer-info'            => 'Transfert de fonds d\'une personne ou d\'un compte à une autre, souvent par voie électronique, à des fins diverses telles que les transactions ou les envois d\'argent.',
                    'page-title'                     => 'Méthodes de paiement',
                    'paid'                           => 'Payé',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'Bouton PayPal Smart : Simplifie les paiements en ligne avec des boutons personnalisables pour des transactions sécurisées et multi-méthodes sur les sites Web et les applications.',
                    'paypal-standard'                => 'PayPal Standard',
                    'paypal-standard-info'           => 'PayPal Standard est une option de paiement PayPal de base pour les entreprises en ligne, permettant aux clients de payer avec leur compte PayPal ou leur carte de crédit/débit.',
                    'pending'                        => 'En attente',
                    'pending-payment'                => 'Paiement en attente',
                    'processing'                     => 'En cours de traitement',
                    'sandbox'                        => 'Environnement de test',
                    'set-invoice-status'             => 'Définir le statut de la facture après sa création sur',
                    'set-order-status'               => 'Définir le statut de la commande après la création de la facture sur',
                    'sort-order'                     => 'Ordre de tri',
                    'status'                         => 'Statut',
                    'title'                          => 'Titre',
                ],

                'order-settings' => [
                    'info'               => 'Définir les numéros de commande, les commandes minimales et les commandes en attente.',
                    'title'              => 'Paramètres de commande',

                    'order-number' => [
                        'generator'   => 'Générateur de numéro de commande',
                        'info'        => 'Identifiant unique attribué à une commande client spécifique, facilitant le suivi, la communication et la référence tout au long du processus d\'achat.',
                        'length'      => 'Longueur du numéro de commande',
                        'prefix'      => 'Préfixe du numéro de commande',
                        'suffix'      => 'Suffixe du numéro de commande',
                        'title'       => 'Paramètres du numéro de commande',
                    ],

                    'minimum-order' => [
                        'description'             => 'Description',
                        'enable'                  => 'Activer',
                        'include-discount-amount' => 'Inclure le montant de la remise',
                        'include-tax-amount'      => 'Inclure la taxe dans le montant',
                        'info'                    => 'Critères configurés spécifiant la quantité ou la valeur minimale requise pour qu\'une commande soit traitée ou bénéficie d\'avantages.',
                        'minimum-order-amount'    => 'Montant minimum de commande',
                        'title'                   => 'Paramètres de commande minimale',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Réorganiser par l\'administrateur',
                        'admin-reorder-info' => 'Activer ou désactiver la fonction de réorganisation pour les utilisateurs administrateurs.',
                        'info'               => 'Activer ou désactiver la fonction de réorganisation pour les utilisateurs de la boutique.',
                        'shop-reorder'       => 'Réorganiser par la boutique',
                        'shop-reorder-info'  => 'Activer ou désactiver la fonction de réorganisation pour les utilisateurs de la boutique.',
                        'title'              => 'Autoriser la réorganisation',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Autoriser les commandes en attente',
                        'info'              => 'Les options de stock sont des contrats d\'investissement qui accordent le droit d\'acheter ou de vendre des actions d\'une entreprise à un prix prédéterminé, influençant les bénéfices potentiels.',
                        'title'             => 'Options de stock',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Définir le numéro de facture, les conditions de paiement, la conception du bon de livraison et les rappels de facture.',
                    'title' => 'Paramètres de facture',

                    'invoice-number' => [
                        'generator'  => 'Générateur de numéro de facture',
                        'info'       => 'Configuration des règles ou des paramètres pour générer et attribuer des numéros d\'identification uniques aux factures à des fins organisationnelles et de suivi.',
                        'length'     => 'Longueur du numéro de facture',
                        'prefix'     => 'Préfixe du numéro de facture',
                        'suffix'     => 'Suffixe du numéro de facture',
                        'title'      => 'Paramètres du numéro de facture',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Durée d\'échéance',
                        'due-duration-day'  => ':due-duration jour',
                        'due-duration-days' => ':due-duration jours',
                        'info'              => 'Conditions convenues dictant quand et comment le paiement des biens ou services doit être effectué par l\'acheteur au vendeur.',
                        'title'             => 'Conditions de paiement',
                    ],

                    'pdf-print-outs' => [
                        'footer-text'      => 'Texte de pied de page',
                        'footer-text-info' => 'Saisissez le texte qui apparaîtra dans le pied de page du PDF.',
                        'info'             => 'Configurer les impressions PDF pour afficher l\'ID de la facture, l\'ID de la commande dans l\'en-tête et inclure le logo de la facture.',
                        'invoice-id-info'  => 'Configurer l\'affichage de l\'ID de la facture dans l\'en-tête de la facture.',
                        'invoice-id-title' => 'Afficher l\'ID de la facture dans l\'en-tête',
                        'logo'             => 'Logo',
                        'logo-info'        => 'La résolution de l\'image doit être de 131px x 30px.',
                        'order-id-info'    => 'Configurer l\'affichage de l\'ID de la commande dans l\'en-tête de la facture.',
                        'order-id-title'   => 'Afficher l\'ID de la commande dans l\'en-tête',
                        'title'            => 'Impressions PDF',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Notifications ou communications automatisées envoyées aux clients pour leur rappeler les paiements à venir ou en retard pour les factures.',
                        'interval-between-reminders' => 'Intervalle entre les rappels',
                        'maximum-limit-of-reminders' => 'Limite maximale de rappels',
                        'title'                      => 'Rappels de facture',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Taxes',
                    'title-info' => 'Les taxes sont des frais obligatoires imposés par les gouvernements sur les biens, les services ou les transactions, collectés par les vendeurs et remis aux autorités.',

                    'categories' => [
                        'title'      => 'Catégories de taxes',
                        'title-info' => 'Les catégories de taxes sont des classifications pour différents types de taxes, telles que la taxe de vente, la taxe sur la valeur ajoutée ou la taxe d\'accise, utilisées pour catégoriser et appliquer des taux de taxe aux produits ou services.',
                        'product'    => 'Catégorie de taxe par défaut du produit',
                        'shipping'   => 'Catégorie de taxe d\'expédition',
                        'none'       => 'Aucune',
                    ],

                    'calculation' => [
                        'title'            => 'Paramètres de calcul',
                        'title-info'       => 'Détails sur le coût des biens ou services, y compris le prix de base, les remises, les taxes et les frais supplémentaires.',
                        'based-on'         => 'Calcul basé sur',
                        'shipping-address' => 'Adresse de livraison',
                        'billing-address'  => 'Adresse de facturation',
                        'shipping-origin'  => 'Origine de l\'expédition',
                        'product-prices'   => 'Prix des produits',
                        'shipping-prices'  => 'Prix d\'expédition',
                        'excluding-tax'    => 'Hors taxe',
                        'including-tax'    => 'Toutes taxes comprises',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'Pays par défaut',
                        'default-post-code' => 'Code postal par défaut',
                        'default-state'     => 'État par défaut',
                        'title'             => 'Calcul de destination par défaut',
                        'title-info'        => 'Détermination automatisée d\'une destination standard ou initiale en fonction de facteurs ou de paramètres prédéfinis.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Paramètres d\'affichage du panier',
                        'title-info'              => 'Définir l\'affichage des taxes dans le panier',
                        'display-prices'          => 'Afficher les prix',
                        'display-subtotal'        => 'Afficher le sous-total',
                        'display-shipping-amount' => 'Afficher le montant de l\'expédition',
                        'excluding-tax'           => 'Hors taxe',
                        'including-tax'           => 'Toutes taxes comprises',
                        'both'                    => 'Hors taxe et toutes taxes comprises',
                    ],

                    'sales' => [
                        'title'                   => 'Paramètres d\'affichage des commandes, des factures et des remboursements',
                        'title-info'              => 'Définir l\'affichage des taxes dans les commandes, les factures et les remboursements',
                        'display-prices'          => 'Afficher les prix',
                        'display-subtotal'        => 'Afficher le sous-total',
                        'display-shipping-amount' => 'Afficher le montant de l\'expédition',
                        'excluding-tax'           => 'Hors taxe',
                        'including-tax'           => 'Toutes taxes comprises',
                        'both'                    => 'Hors taxe et toutes taxes comprises',
                    ],
                ],

                'checkout' => [
                    'title' => 'Validation de la commande',
                    'info'  => 'Définir le paiement en tant qu\'invité, activer ou désactiver le mini-panier, résumé du panier.',

                    'shopping-cart' => [
                        'cart-page'              => 'Page du panier',
                        'cart-page-info'         => 'Contrôler la visibilité de la page du panier pour améliorer l\'expérience d\'achat de l\'utilisateur.',
                        'cross-sell'             => 'Produits complémentaires',
                        'cross-sell-info'        => 'Activer les produits complémentaires pour augmenter les opportunités de vente supplémentaires.',
                        'estimate-shipping'      => 'Estimation des frais de livraison',
                        'estimate-shipping-info' => 'Activer l\'estimation des frais de livraison pour fournir les coûts d\'expédition anticipés.',
                        'guest-checkout'         => 'Autoriser la commande en tant qu\'invité',
                        'guest-checkout-info'    => 'Activer la commande en tant qu\'invité pour un processus d\'achat plus rapide et sans tracas.',
                        'info'                   => 'Activer la commande en tant qu\'invité, la page du panier, les produits complémentaires et l\'estimation des frais de livraison pour améliorer la commodité de l\'utilisateur et rationaliser le processus d\'achat pour augmenter les ventes.',
                        'title'                  => 'Panier d\'achat',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Afficher les quantités d\'articles',
                        'display-number-in-cart'  => 'Afficher le nombre d\'articles dans le panier',
                        'info'                    => 'Activer les paramètres de Mon panier pour afficher un résumé des quantités d\'articles et afficher le nombre total d\'articles dans le panier pour un suivi facile.',
                        'summary'                 => 'Résumé',
                        'title'                   => 'Mon panier',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Afficher le mini panier',
                        'info'                 => 'Activer les paramètres du mini panier pour afficher le mini panier et afficher les informations sur les offres du mini panier pour un accès rapide aux détails du panier et aux promotions.',
                        'mini-cart-offer-info' => 'Informations sur les offres du mini panier',
                        'title'                => 'Mini panier',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Compte',
                'app-version'   => 'Version : :version',
                'logout'        => 'Déconnexion',
                'my-account'    => 'Mon Compte',
                'notifications' => 'Notifications',
                'visit-shop'    => 'Visiter la Boutique',

                'mega-search' => [
                    'categories'                      => 'Catégories',
                    'customers'                       => 'Clients',
                    'explore-all-categories'          => 'Explorer toutes les catégories',
                    'explore-all-customers'           => 'Explorer tous les clients',
                    'explore-all-matching-categories' => 'Explorer toutes les catégories correspondant à “:query” (:count)',
                    'explore-all-matching-customers'  => 'Explorer tous les clients correspondant à “:query” (:count)',
                    'explore-all-matching-orders'     => 'Explorer toutes les commandes correspondant à “:query” (:count)',
                    'explore-all-matching-products'   => 'Explorer tous les produits correspondant à “:query” (:count)',
                    'explore-all-orders'              => 'Explorer toutes les commandes',
                    'explore-all-products'            => 'Explorer tous les produits',
                    'orders'                          => 'Commandes',
                    'products'                        => 'Produits',
                    'sku'                             => 'SKU : :sku',
                    'title'                           => 'Méga Recherche',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Familles d\'attributs',
                'attributes'               => 'Attributs',
                'booking-product'          => 'Réservations',
                'campaigns'                => 'Campagnes',
                'catalog'                  => 'Catalogue',
                'categories'               => 'Catégories',
                'channels'                 => 'Canaux',
                'cms'                      => 'CMS',
                'collapse'                 => 'Réduire',
                'communications'           => 'Communications',
                'configure'                => 'Configurer',
                'currencies'               => 'Devises',
                'customers'                => 'Clients',
                'dashboard'                => 'Tableau de bord',
                'data-transfer'            => 'Transfert de données',
                'discount'                 => 'Remise',
                'email-templates'          => 'Modèles d\'email',
                'events'                   => 'Événements',
                'exchange-rates'           => 'Taux de change',
                'gdpr-data-requests'       => 'Demandes de données GDPR',
                'groups'                   => 'Groupes',
                'imports'                  => 'Importations',
                'inventory-sources'        => 'Sources de l\'inventaire',
                'invoices'                 => 'Factures',
                'locales'                  => 'Paramètres régionaux',
                'marketing'                => 'Marketing',
                'mode'                     => 'Mode sombre',
                'newsletter-subscriptions' => 'Abonnements à la newsletter',
                'orders'                   => 'Commandes',
                'products'                 => 'Produits',
                'promotions'               => 'Promotions',
                'refunds'                  => 'Remboursements',
                'reporting'                => 'Rapport',
                'reviews'                  => 'Avis',
                'roles'                    => 'Rôles',
                'sales'                    => 'Ventes',
                'search-seo'               => 'Recherche et référencement',
                'search-synonyms'          => 'Synonymes de recherche',
                'search-terms'             => 'Termes de recherche',
                'settings'                 => 'Paramètres',
                'shipments'                => 'Expéditions',
                'sitemaps'                 => 'Plans du site',
                'tax-categories'           => 'Catégories de taxes',
                'tax-rates'                => 'Taux de taxes',
                'taxes'                    => 'Taxes',
                'themes'                   => 'Thèmes',
                'transactions'             => 'Transactions',
                'url-rewrites'             => 'Réécritures d\'URL',
                'users'                    => 'Utilisateurs',
            ],

            'powered-by' => [
                'description' => 'Propulsé par :bagisto, un projet open-source par :webkul.',
            ],
        ],

        'datagrid' => [
            'index' => [
                'no-records-selected'              => 'Aucun enregistrement sélectionné.',
                'must-select-a-mass-action-option' => 'Vous devez sélectionner une option pour l\'action de masse.',
                'must-select-a-mass-action'        => 'Vous devez sélectionner une action de masse.',
            ],

            'toolbar' => [
                'length-of' => ':length de',
                'of'        => 'de',
                'per-page'  => 'Par page',
                'results'   => ':total Résultats',
                'selected'  => ':total Sélectionnés',

                'mass-actions' => [
                    'select-action' => 'Sélectionner l\'action',
                    'select-option' => 'Sélectionner une option',
                    'submit'        => 'Soumettre',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Appliquer les filtres',
                    'back-btn'          => 'Retour',
                    'create-new-filter' => 'Créer un nouveau filtre',
                    'custom-filters'    => 'Filtres personnalisés',
                    'delete-error'      => 'Une erreur s\'est produite lors de la suppression du filtre, veuillez réessayer.',
                    'delete-success'    => 'Le filtre a été supprimé avec succès.',
                    'empty-description' => 'Aucun filtre sélectionné n\'est disponible pour être enregistré. Veuillez sélectionner des filtres à enregistrer.',
                    'empty-title'       => 'Ajouter des filtres à enregistrer',
                    'name'              => 'Nom',
                    'quick-filters'     => 'Filtres rapides',
                    'save-btn'          => 'Enregistrer',
                    'save-filter'       => 'Enregistrer le filtre',
                    'saved-success'     => 'Le filtre a été enregistré avec succès.',
                    'selected-filters'  => 'Filtres sélectionnés',
                    'title'             => 'Filtre',
                    'update'            => 'Mettre à jour',
                    'update-filter'     => 'Mettre à jour le filtre',
                    'updated-success'   => 'Le filtre a été mis à jour avec succès.',
                ],

                'search' => [
                    'title' => 'Rechercher',
                ],
            ],

            'filters' => [
                'select' => 'Sélectionner.',
                'title'  => 'Filtres',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Tapez au moins 2 caractères...',
                        'no-results'        => 'Aucun résultat trouvé...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Tout effacer',
                    'title'     => 'Filtres personnalisés',
                ],

                'boolean-options' => [
                    'false' => 'Faux',
                    'true'  => 'Vrai',
                ],

                'date-options' => [
                    'last-month'        => 'Le mois dernier',
                    'last-six-months'   => 'Les 6 derniers mois',
                    'last-three-months' => 'Les 3 derniers mois',
                    'this-month'        => 'Ce mois-ci',
                    'this-week'         => 'Cette semaine',
                    'this-year'         => 'Cette année',
                    'today'             => 'Aujourd\'hui',
                    'yesterday'         => 'Hier',
                ],
            ],

            'table' => [
                'actions'              => 'Actions',
                'no-records-available' => 'Aucun enregistrement disponible.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'D\'accord',
                'disagree-btn' => 'Pas d\'accord',
                'message'      => 'Êtes-vous sûr(e) de vouloir effectuer cette action ?',
                'title'        => 'Êtes-vous sûr(e) ?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Ajouter le produit sélectionné',
                'empty-info'    => 'Aucun produit disponible pour le terme de recherche.',
                'empty-title'   => 'Aucun produit trouvé',
                'product-image' => 'Image du produit',
                'qty'           => ':qty disponible',
                'sku'           => 'SKU - :sku',
                'title'         => 'Sélectionner des produits',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => 'Ajouter une image',
                'ai-add-image-btn'  => 'IA Magique',
                'ai-btn-info'       => 'Générer une Image',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Seuls les fichiers d\'images (.jpeg, .jpg, .png, ..) sont autorisés.',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Appliquer',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => 'Générer',
                    'generating'       => 'Génération en cours...',
                    'hd'               => 'HD',
                    'model'            => 'Modèle',
                    'number-of-images' => 'Nombre d\'images',
                    'prompt'           => 'Indication',
                    'quality'          => 'Qualité',
                    'regenerate'       => 'Régénérer',
                    'regenerating'     => 'Régénération en cours...',
                    'size'             => 'Taille',
                    'standard'         => 'Standard',
                    'title'            => 'Génération d\'images par IA',
                ],

                'placeholders' => [
                    'front'     => 'Avant',
                    'next'      => 'Suivant',
                    'size'      => 'Taille',
                    'use-cases' => 'Utilisations',
                    'zoom'      => 'Zoom',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Ajouter une vidéo',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Seuls les fichiers vidéo (.mp4, .mov, .ogg ..) sont autorisés.',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Magie IA',

            'ai-generation' => [
                'apply'                    => 'Appliquer',
                'deepseek-r1-8b'           => 'DeepSeek R1 (8b)',
                'enabled'                  => 'Activé',
                'gemini-2-0-flash'         => 'Gemini 2.0 Flash',
                'generate'                 => 'Générer',
                'generated-content'        => 'Contenu généré',
                'generated-content-info'   => 'Le contenu généré par l\'IA peut être trompeur. Veuillez examiner le contenu généré avant de l\'appliquer.',
                'generating'               => 'Génération en cours...',
                'gpt-4-turbo'              => 'OpenAI gpt-4 Turbo',
                'gpt-4o'                   => 'OpenAI gpt-4o',
                'gpt-4o-mini'              => 'OpenAI gpt-4o mini',
                'llama-groq'               => 'Llama 3.3 (Groq)',
                'llama3-1-8b'              => 'Llama 3.1 (8B)',
                'llama3-2-1b'              => 'Llama 3.2 (1B)',
                'llama3-2-3b'              => 'Llama 3.2 (3B)',
                'llama3-8b'                => 'Llama 3 (8B)',
                'llava-7b'                 => 'Llava (7b)',
                'mistral-7b'               => 'Mistral (7b)',
                'model'                    => 'Modèle',
                'orca-mini'                => 'Orca Mini',
                'phi3-5'                   => 'Phi 3.5',
                'prompt'                   => 'Invite',
                'qwen2-5-0-5b'             => 'Qwen 2.5 (0.5b)',
                'qwen2-5-1-5b'             => 'Qwen 2.5 (1.5b)',
                'qwen2-5-14b'              => 'Qwen 2.5 (14b)',
                'qwen2-5-3b'               => 'Qwen 2.5 (3b)',
                'qwen2-5-7b'               => 'Qwen 2.5 (7b)',
                'starling-lm-7b'           => 'Starling-lm (7b)',
                'title'                    => 'Assistance IA',
                'vicuna-13b'               => 'Vicuna (13b)',
                'vicuna-7b'                => 'Vicuna (7b)',
            ],

            'errors' => [
                'file-extension-mismatch'        => 'L\'extension du fichier ne correspond pas au type de fichier.',
                'file-upload-failed'             => 'Échec du téléchargement du fichier.',
                'http-error'                     => 'Erreur HTTP.',
                'invalid-file-type'              => 'Type de fichier non valide. Types autorisés : JPEG, PNG, GIF, WebP, SVG',
                'invalid-json'                   => 'JSON non valide.',
                'no-file-uploaded'               => 'Aucun fichier téléchargé.',
                'upload-failed'                  => 'Le téléchargement de l\'image a échoué en raison d\'une erreur de transport XHR.',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Adresses',
        'attribute-families'       => 'Familles d\'attributs',
        'attributes'               => 'Attributs',
        'campaigns'                => 'Campagnes',
        'cancel'                   => 'Annuler',
        'cart-rules'               => 'Règles du panier',
        'catalog-rules'            => 'Règles du catalogue',
        'catalog'                  => 'Catalogue',
        'categories'               => 'Catégories',
        'channels'                 => 'Canaux',
        'cms'                      => 'CMS',
        'communications'           => 'Communications',
        'configure'                => 'Configurer',
        'copy'                     => 'Copier',
        'create'                   => 'créer',
        'currencies'               => 'Devises',
        'customers'                => 'Clients',
        'dashboard'                => 'Tableau de bord',
        'data-transfer'            => 'Transfert de données',
        'delete'                   => 'Supprimer',
        'edit'                     => 'Modifier',
        'email-templates'          => 'Modèles d\'e-mail',
        'events'                   => 'Événements',
        'exchange-rates'           => 'Taux de change',
        'gdpr'                     => 'RGPD',
        'groups'                   => 'Groupes',
        'import'                   => 'Importer',
        'imports'                  => 'Importations',
        'inventory-sources'        => 'Sources de stock',
        'invoices'                 => 'Factures',
        'locales'                  => 'Paramètres régionaux',
        'marketing'                => 'Marketing',
        'newsletter-subscriptions' => 'Abonnements à la newsletter',
        'note'                     => 'Note',
        'orders'                   => 'Commandes',
        'products'                 => 'Produits',
        'promotions'               => 'Promotions',
        'refunds'                  => 'Remboursements',
        'reporting'                => 'Rapports',
        'reviews'                  => 'Avis',
        'roles'                    => 'Rôles',
        'sales'                    => 'Ventes',
        'search-seo'               => 'Recherche et référencement',
        'search-synonyms'          => 'Synonymes de recherche',
        'search-terms'             => 'Termes de recherche',
        'settings'                 => 'Paramètres',
        'shipments'                => 'Expéditions',
        'sitemaps'                 => 'Sitemaps',
        'subscribers'              => 'Abonnés à la newsletter',
        'tax-categories'           => 'Catégories de taxes',
        'tax-rates'                => 'Taux de taxes',
        'taxes'                    => 'Taxes',
        'themes'                   => 'Thèmes',
        'transactions'             => 'Transactions',
        'url-rewrites'             => 'Réécritures d\'URL',
        'users'                    => 'Utilisateurs',
        'view'                     => 'Voir',
    ],

    'errors' => [
        'dashboard' => 'Tableau de bord',
        'go-back'   => 'Retour',
        'support'   => 'Si le problème persiste, contactez-nous à <a href=":link" class=":class">:email</a> pour obtenir de l\'aide.',

        '404' => [
            'description' => 'Oups ! La page que vous recherchez est en vacances. Il semble que nous n\'ayons pas pu trouver ce que vous cherchiez.',
            'title'       => '404 Page non trouvée',
        ],

        '401' => [
            'description' => 'Oups ! Il semble que vous n\'ayez pas le droit d\'accéder à cette page. Vous semblez manquer des informations d\'identification nécessaires.',
            'title'       => '401 Non autorisé',
        ],

        '403' => [
            'description' => 'Oups ! Cette page est interdite. Il semble que vous n\'ayez pas les autorisations nécessaires pour voir ce contenu.',
            'title'       => '403 Interdit',
        ],

        '500' => [
            'description' => 'Oups ! Quelque chose s\'est mal passé. Il semble que nous ayons des problèmes pour charger la page que vous recherchez.',
            'title'       => '500 Erreur interne du serveur',
        ],

        '503' => [
            'description' => 'Oups ! Il semble que nous soyons temporairement en maintenance. Veuillez revenir dans un moment.',
            'title'       => '503 Service indisponible',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Télécharger',
        'export'     => 'Exporter',
        'no-records' => 'Rien à exporter',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Ce slug est utilisé dans les catégories ou les produits.',
        'slug-reserved'   => 'Ce slug est réservé.',
    ],

    'footer' => [
        'copy-right' => 'Propulsé par <a href="https://bagisto.com/" target="_blank">Bagisto</a>, un projet communautaire par <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Cher :admin_name',
        'thanks' => 'Si vous avez besoin d\'aide, veuillez nous contacter à <a href=":link" style=":style">:email</a>.<br/>Merci !',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Vous recevez cet e-mail car nous avons reçu une demande de réinitialisation de mot de passe pour votre compte.',
                'greeting'       => 'Mot de passe oublié !',
                'reset-password' => 'Réinitialiser le mot de passe',
                'subject'        => 'E-mail de réinitialisation de mot de passe',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'Un nouveau compte client a été créé avec succès. Ils peuvent désormais se connecter en utilisant leur adresse e-mail et leur mot de passe. Une fois connectés, ils auront accès à divers services, notamment la possibilité de consulter les commandes passées, de gérer les listes de souhaits et de mettre à jour les informations de leur compte.',
                'greeting'    => 'Nous souhaitons la bienvenue au nouveau client, :customer_name qui vient de s`inscrire chez nous !',
                'subject'     => 'Enregistrement d`un nouveau client',
            ],

            'gdpr' => [
                'new-delete-request' => 'Nouvelle demande de suppression de données',
                'new-update-request' => 'Nouvelle demande de mise à jour des données',

                'new-request' => [
                    'customer-name'  => 'Nom du client : ',
                    'delete-summary' => 'Résumé de la demande de suppression',
                    'message'        => 'Message : ',
                    'request-status' => 'Statut de la demande : ',
                    'request-type'   => 'Type de demande : ',
                    'update-summary' => 'Résumé de la demande de mise à jour',
                ],

                'status-update' => [
                    'subject'        => 'La demande GDPR a été mise à jour',
                    'summary'        => 'Le statut de la demande GDPR a été mis à jour',
                    'request-status' => 'Statut de la demande:',
                    'request-type'   => 'Type de demande:',
                    'message'        => 'Message:',
                ],
            ],
        ],

        'orders' => [
            'created' => [
                'subject'  => 'Confirmation de nouvelle commande',
                'title'    => 'Confirmation de commande !',
                'greeting' => 'Vous avez une nouvelle commande :order_id passée le :created_at',
                'summary'  => 'Résumé de la commande',
            ],

            'invoiced' => [
                'greeting' => 'Votre facture n° :invoice_id pour la commande :order_id créée le :created_at',
                'subject'  => 'Nouvelle confirmation de facture',
                'summary'  => 'Résumé de la facture',
                'title'    => 'Confirmation de facture !',
            ],

            'shipped' => [
                'greeting' => 'Vous avez expédié la commande :order_id passée le :created_at',
                'subject'  => 'Confirmation d\'expédition',
                'summary'  => 'Résumé de l\'expédition',
                'title'    => 'Commande expédiée !',
            ],

            'inventory-source' => [
                'greeting' => 'Vous avez expédié la commande :order_id passée le :created_at',
                'subject'  => 'Confirmation d\'expédition',
                'summary'  => 'Résumé de l\'expédition',
                'title'    => 'Commande expédiée !',
            ],

            'refunded' => [
                'greeting' => 'Vous avez remboursé la commande :order_id passée le :created_at',
                'subject'  => 'Confirmation de remboursement',
                'summary'  => 'Résumé du remboursement',
                'title'    => 'Commande remboursée !',
            ],

            'canceled' => [
                'greeting' => 'Vous avez annulé la commande :order_id passée le :created_at',
                'subject'  => 'Commande annulée',
                'summary'  => 'Résumé de la commande',
                'title'    => 'Commande annulée !',
            ],

            'billing-address'            => 'Adresse de facturation',
            'carrier'                    => 'Transporteur',
            'contact'                    => 'Contact',
            'discount'                   => 'Remise',
            'excl-tax'                   => 'Hors taxes : ',
            'grand-total'                => 'Total général',
            'name'                       => 'Nom',
            'payment'                    => 'Paiement',
            'price'                      => 'Prix',
            'qty'                        => 'Quantité',
            'shipping-address'           => 'Adresse de livraison',
            'shipping-handling-excl-tax' => 'Frais de port (hors taxes)',
            'shipping-handling-incl-tax' => 'Frais de port (taxes incluses)',
            'shipping-handling'          => 'Frais de port',
            'shipping'                   => 'Livraison',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Sous-total (hors taxes)',
            'subtotal-incl-tax'          => 'Sous-total (taxes incluses)',
            'subtotal'                   => 'Sous-total',
            'tax'                        => 'Taxe',
            'tracking-number'            => 'Numéro de suivi : :tracking_number',
        ],
    ],
];
